import Vue from 'vue';
import VueRouter from 'vue-router';
Vue.use(VueRouter);

import dashboard from "../sections/dashboard.vue";
import change_password from "../sections/change_password.vue";

import workers from "../sections/workers/workers.vue";
import workers_list from "../sections/workers/list.vue";
import workers_add from "../sections/workers/form.vue";

import providers from "../sections/providers/providers.vue";
import providers_list from "../sections/providers/list.vue";
import providers_add from "../sections/providers/form.vue";

import parts from "../sections/parts/parts.vue";
import parts_list from "../sections/parts/list.vue";
import parts_add from "../sections/parts/form.vue";

import provider_bills from "../sections/provider_bills/provider_bills.vue";
import provider_bills_list from "../sections/provider_bills/list.vue";
import provider_bills_add from "../sections/provider_bills/form.vue";

import invoices from "../sections/invoices/invoices.vue";
import invoices_list from "../sections/invoices/list.vue";
import invoices_add from "../sections/invoices/form.vue";

import estimates from "../sections/estimates/estimates.vue";
import estimates_list from "../sections/estimates/list.vue";
import estimates_add from "../sections/estimates/form.vue";

import rent from "../sections/rent/rent.vue";
import rent_list from "../sections/rent/list.vue";
import rent_add from "../sections/rent/form.vue";

import clients from "../sections/clients/clients.vue";
import clients_list from "../sections/clients/list.vue";
import clients_add from "../sections/clients/form.vue";

import reports from "../sections/reports/reports.vue";
import reports_balance from "../sections/reports/balance.vue";
import reports_cash from "../sections/reports/cash.vue";
import reports_check from "../sections/reports/check.vue";
import reports_debit from "../sections/reports/debit.vue";
import reports_credit from "../sections/reports/credit.vue";
import reports_workers_salary from "../sections/reports/workers_salary.vue";
import reports_parts_expenses from "../sections/reports/parts_expenses.vue";
import reports_incomes from "../sections/reports/incomes.vue";

export default  new VueRouter({
    routes : [
        { name:'dashboard',meta: {id: 'dashboard'}, path: '/', component: dashboard, props: true},
        { name:'change_password', path: '/change-password', component: change_password, props: true},
        {
            name: 'workers',
            meta: {id: 'workers'},
            path: '/workers',
            redirect: '/workers/list',
            component: workers,
            // Children is just another route definition of sub-routes.
            children: [
                {
                    name: 'workers list',
                    meta: {id: 'workers'},
                    path: '/workers/list',
                    component: workers_list,
                },
                {
                    name: 'workers form add',
                    meta: {id: 'workers'},
                    path: '/workers/form/',
                    component: workers_add,
                },
                {
                    name: 'workers form edit',
                    meta: {id: 'workers'},
                    path: '/workers/form/:id',
                    component: workers_add,
                },
            ]
        },
        {
            name: 'providers',
            meta: {id: 'providers'},
            path: '/providers',
            redirect: '/providers/list',
            component: providers,
            // Children is just another route definition of sub-routes.
            children: [
                {
                    name: 'providers list',
                    meta: {id: 'providers'},
                    path: '/providers/list',
                    component: providers_list,
                },
                {
                    name: 'providers form add',
                    meta: {id: 'providers'},
                    path: '/providers/form',
                    component: providers_add,
                },
                {
                    name: 'providers form edit',
                    meta: {id: 'providers'},
                    path: '/providers/form/:id',
                    component: providers_add,
                },
            ]
        },
        {
            name: 'parts',
            meta: {id: 'parts'},
            path: '/parts',
            redirect: '/parts/list',
            component: parts,
            // Children is just another route definition of sub-routes.
            children: [
                {
                    name: 'parts list',
                    meta: {id: 'parts'},
                    path: '/parts/list',
                    component: parts_list,
                },
                {
                    name: 'parts form add',
                    meta: {id: 'parts'},
                    path: '/parts/form',
                    component: parts_add,
                },
                {
                    name: 'parts form edit',
                    meta: {id: 'parts'},
                    path: '/parts/form/:id',
                    component: parts_add,
                },
            ]
        },
        {
            name: 'provider bills',
            meta: {id: 'provider-bills'},
            path: '/provider-bills',
            redirect: '/provider-bills/list',
            component: provider_bills,
            // Children is just another route definition of sub-routes.
            children: [
                {
                    name: 'provider bills list',
                    meta: {id: 'provider-bills'},
                    path: '/provider-bills/list',
                    component: provider_bills_list,
                },
                {
                    name: 'provider bills form add',
                    meta: {id: 'provider-bills'},
                    path: '/provider-bills/form',
                    component: provider_bills_add,
                },
                {
                    name: 'provider bills form edit',
                    meta: {id: 'provider-bills'},
                    path: '/provider-bills/form/:id',
                    component: provider_bills_add,
                },
            ]
        },
        {
            name: 'invoices',
            meta: {id: 'invoices'},
            path: '/invoices',
            redirect: '/invoices/list',
            component: invoices,
            // Children is just another route definition of sub-routes.
            children: [
                {
                    name: 'invoices list',
                    meta: {id: 'invoices'},
                    path: '/invoices/list',
                    component: invoices_list,
                },
                {
                    name: 'invoices form add',
                    meta: {id: 'invoices'},
                    path: '/invoices/form',
                    component: invoices_add,
                },
                {
                    name: 'invoices form edit',
                    meta: {id: 'invoices'},
                    path: '/invoices/form/:id',
                    component: invoices_add,
                },
            ]
        },
        {
            name: 'estimates',
            meta: {id: 'estimates'},
            path: '/estimates',
            redirect: '/estimates/list',
            component: estimates,
            // Children is just another route definition of sub-routes.
            children: [
                {
                    name: 'estimates list',
                    meta: {id: 'estimates'},
                    path: '/estimates/list',
                    component: estimates_list,
                },
                {
                    name: 'estimates form add',
                    meta: {id: 'estimates'},
                    path: '/estimates/form',
                    component: estimates_add,
                },
                {
                    name: 'estimates form edit',
                    meta: {id: 'estimates'},
                    path: '/estimates/form/:id',
                    component: estimates_add,
                },
            ]
        },
        {
            name: 'rent',
            meta: {id: 'rent'},
            path: '/rent',
            redirect: '/rent/list',
            component: rent,
            // Children is just another route definition of sub-routes.
            children: [
                {
                    name: 'rent list',
                    meta: {id: 'rent'},
                    path: '/rent/list',
                    component: rent_list,
                },
                {
                    name: 'rent form',
                    meta: {id: 'rent'},
                    path: '/rent/form/:id',
                    component: rent_add,
                },
            ]
        },
        {
            name: 'reports',
            meta: {id: 'reports'},
            path: '/reports',
            redirect: '/reports/balance',
            component: reports,
            // Children is just another route definition of sub-routes.
            children: [
                {
                    name: 'reports balance',
                    meta: {id: 'reports'},
                    path: '/reports/balance',
                    component: reports_balance,
                },
                {
                    name: 'reports cash',
                    meta: {id: 'reports'},
                    path: '/reports/cash',
                    component: reports_cash,
                },
                {
                    name: 'reports check',
                    meta: {id: 'reports'},
                    path: '/reports/check',
                    component: reports_check,
                },
                {
                    name: 'reports debit',
                    meta: {id: 'reports'},
                    path: '/reports/debit',
                    component: reports_debit,
                },
                {
                    name: 'reports credit',
                    meta: {id: 'reports'},
                    path: '/reports/credit',
                    component: reports_credit,
                },
                {
                    name: 'reports workers salary',
                    meta: {id: 'reports'},
                    path: '/reports/workers-salary',
                    component: reports_workers_salary,
                },
                {
                    name: 'reports parts expenses',
                    meta: {id: 'reports'},
                    path: '/reports/parts-expenses',
                    component: reports_parts_expenses,
                },
                {
                    name: 'reports incomes',
                    meta: {id: 'reports'},
                    path: '/reports/incomes',
                    component: reports_incomes,
                },
            ]
        },
        {
            name: 'clients',
            meta: {id: 'clients'},
            path: '/clients',
            redirect: '/clients/list',
            component: clients,
            // Children is just another route definition of sub-routes.
            children: [
                {
                    name: 'clients list',
                    meta: {id: 'clients'},
                    path: '/clients/list',
                    component: clients_list,
                },
                {
                    name: 'clients form add',
                    meta: {id: 'clients'},
                    path: '/clients/form/',
                    component: clients_add,
                },
                {
                    name: 'clients form edit',
                    meta: {id: 'clients'},
                    path: '/clients/form/:id',
                    component: clients_add,
                },
            ]
        },
    ]
});