<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateInvoicePartsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('invoice_parts', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('invoice_id')->unsigned();
            $table->integer('part_id')->unsigned();
            $table->integer('quantity')->unsigned()->nullable();
            $table->string('part_number')->nullable();
            $table->string('name')->nullable();
            $table->string('description')->nullable();
            $table->double('extend')->unsigned()->nullable();
            $table->double('price')->unsigned()->nullable();
            $table->string('warranty')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('invoice_parts');
    }
}
