<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreatePartsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('parts', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('provider_id')->unsigned()->nullable();
            $table->integer('bill_id')->unsigned()->nullable();
            $table->integer('quantity')->unsigned()->nullable();
            $table->string('part_number')->nullable();
            $table->string('name')->nullable();
            $table->string('description')->nullable();
            $table->double('extend')->unsigned()->nullable();
            $table->double('price')->unsigned()->nullable();
            $table->string('warranty')->nullable();
            $table->boolean('deleted')->default(0);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('parts');
    }
}
