<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Part extends Model
{
    protected $fillable = [
        'provider_id', 
        "bill_id",
        "name",
        "part_number", 
        "quantity", 
        "description", 
        "extend", 
        "price", 
        "warranty"
        ];
    public function provider()
    {
        return $this->belongsTo(Provider::class);
    }
    public function iParts()
    {
        return $this->hasMany(InvoicePart::class);
    }
}
