<?php

namespace App\Libraries;

use App\Anuncio;
use App\Invoice;
use App\Worker;
use App\Categoria;
use App\Setting;
use App\SubCategoria;

class Common
{

    public function __construct()
    {
    }
    
    static public function billRow($billsDetail, $parts, $i) {
        $string = "";
        if(count($billsDetail) > $i) {
        $string = '     <td class="col_qty pdftd"><p style="" class="pmore1">'.$billsDetail[$i]->quantity.'</p></td>
                        <td class="col_part pdftd"><p style="" class="pmore1">'.$billsDetail[$i]->part_number.'</p></td>
                        <td class="col_dsc pdftd"><p style="" class="pmore1">'.$billsDetail[$i]->description.'</p></td>
                        <td class="col_prc pdftd"><p style="" class="pmore1">'.number_format($billsDetail[$i]->price, 2).'</p></td>
                        <td class="col_prc pdftd"><p style="" class="pmore1">'.$billsDetail[$i]->warranty_client.'</p></td>';
        }
        else if(count($parts) > ($i - count($billsDetail))){
            $j = $i - count($billsDetail);
        $string = '     <td class="col_qty pdftd"><p style="" class="pmore1">'.$parts[$j]->quantity.'</p></td>
                        <td class="col_part pdftd"><p style="" class="pmore1">'.$parts[$j]->part_number.'</p></td>
                        <td class="col_dsc pdftd"><p style="" class="pmore1">'.$parts[$j]->description.'</p></td>
                        <td class="col_prc pdftd"><p style="" class="pmore1">'.$parts[$j]->price.'</p></td>
                        <td class="col_prc pdftd"><p style="" class="pmore1">'.$parts[$j]->warranty.'</p></td>';
        }
        else {
        $string = '     <td class="col_qty pdftd"><p style="" class="pmore1">&nbsp;</p></td>
                        <td class="col_part pdftd"><p style="" class="pmore1">&nbsp;</p></td>
                        <td class="col_dsc pdftd"><p style="" class="pmore1">&nbsp;</p></td>
                        <td class="col_prc pdftd"><p style="" class="pmore1">&nbsp;</p></td>
                        <td class="col_prc pdftd"><p style="" class="pmore1">&nbsp;</p></td>';
        }
        return $string;
    }
    static public function billRowEstimate($billsDetail, $parts, $i) {
        $string = "";
        if(count($billsDetail) > $i) {
        $string = '     <td class="col_qty pdftd"><p style="" class="pmore1">'.$billsDetail[$i]->quantity.'</p></td>
                        <td class="col_part pdftd"><p style="" class="pmore1">&nbsp;</p></td>
                        <td class="col_dsc pdftd"><p style="" class="pmore1">'.$billsDetail[$i]->name.'</p></td>
                        <td class="col_prc pdftd"><p style="" class="pmore1">'.$billsDetail[$i]->price.'</p></td>
                        <td class="col_prc pdftd"><p style="" class="pmore1">'.$billsDetail[$i]->warranty.'</p></td>';
        }
        else if(count($parts) > ($i - count($billsDetail))){
            $j = $i - count($billsDetail);
        $string = '     <td class="col_qty pdftd"><p style="" class="pmore1">'.$parts[$j]->quantity.'</p></td>
                        <td class="col_part pdftd"><p style="" class="pmore1">'.$parts[$j]->part_number.'</p></td>
                        <td class="col_dsc pdftd"><p style="" class="pmore1">'.$parts[$j]->description.'</p></td>
                        <td class="col_prc pdftd"><p style="" class="pmore1">'.$parts[$j]->price.'</p></td>
                        <td class="col_prc pdftd"><p style="" class="pmore1">'.$parts[$j]->warranty.'</p></td>';
        }
        else {
        $string = '     <td class="col_qty pdftd"><p style="" class="pmore1">&nbsp;</p></td>
                        <td class="col_part pdftd"><p style="" class="pmore1">&nbsp;</p></td>
                        <td class="col_dsc pdftd"><p style="" class="pmore1">&nbsp;</p></td>
                        <td class="col_prc pdftd"><p style="" class="pmore1">&nbsp;</p></td>
                        <td class="col_prc pdftd"><p style="" class="pmore1">&nbsp;</p></td>';
        }
        return $string;
    }
    static public function repairRow($repairs, $i){
        $string = '';
        if(count($repairs) > $i) {
            $string = ' <td colspan="6" class="pdftd"><p style="" class="pmore1">'.$repairs[$i]->description.'</p></td>
                        <td class="pdftd"><p style="" class="pmore1">'.$repairs[$i]->labor.'</p></td>
                        <td class="pdftd"><p style="" class="pmore1">'.$repairs[$i]->time.'</p></td>';
        }
        else {
            $string = ' <td colspan="6" class="pdftd"><p style="" class="pmore1">&nbsp;</p></td>
                        <td class="pdftd"><p style="" class="pmore1">&nbsp;</p></td>
                        <td class="pdftd"><p style="" class="pmore1">&nbsp;</p></td>';
        }
        return $string;
    }
    static public function getSubTotal($invoice) {
        $amount = 0;
        foreach ($invoice->bills as $bill) {
            foreach ($bill->bill_details as $detail) {
                $amount += $detail->quantity * $detail->price;
            }
        }
        foreach ($invoice->parts as $part){
            $amount += $part->quantity * $part->price;
        }
        foreach ($invoice->repairs as $repair){
            $amount += $repair->labor * $repair->time;
        }
        $amount += $invoice->sublet_other;
        $amount += $invoice->shop_supplies;
        $amount += $invoice->fees;
        return $amount;
    }
    static public function getSubTotalEstimate($invoice) {
        $amount = 0;
        foreach ($invoice->eparts as $part){
            $amount += $part->quantity * $part->price;
        }
        foreach ($invoice->parts as $part){
            $amount += $part->quantity * $part->price;
        }
        foreach ($invoice->repairs as $repair){
            $amount += $repair->labor * $repair->time;
        }
        $amount += $invoice->sublet_other;
        $amount += $invoice->shop_supplies;
        $amount += $invoice->fees;
        return $amount;
    }
    static public function getInvoiceNumbers($invoice) {
        $part = 0;
        $part_e = 0;
        $other_part = 0;
        $other_part_e = 0;
        $repair = 0;
        foreach ($invoice->bills as $bill) {
            foreach ($bill->bill_details as $detail) {
                $part += $detail->quantity * $detail->price;
                $part_e += $detail->quantity * $detail->extend;
            }
        }
        foreach ($invoice->parts as $p){
            $other_part += $p->quantity * $p->price;
            $other_part_e += $p->quantity * $p->extend;
        }
        foreach ($invoice->repairs as $r){
            $repair += $r->labor * $r->time;
        }
        return [
            'sub_total' => $part + $other_part + $repair + $invoice->sublet_other + $invoice->shop_supplies + $invoice->fees,
            'part' => $part,
            'part_e' => $part_e,
            'other_part' => $other_part,
            'other_part_e' => $other_part_e,
            'repair' => $repair
        ];
    }
    static public function getRepairs(Invoice $invoice){
        $amount = 0;
        foreach ($invoice->repairs as $repair){
            $amount += $repair->labor * $repair->time;
        }
        return round($amount, 2);
    }
    static public function getWorkerSalary(Worker $worker, $start_date, $end_date) {
        $salary = 0;
        $worker_invoices = $worker->invoices()
                ->where('repair_type', 'invoice')
                ->where("form_date", ">", date('Y-m-d H:i:s', strtotime($start_date)))
                ->where("form_date", "<=", date('Y-m-d H:i:s', strtotime($end_date." 23:59:59")))
                ->get();
        if($worker->is_main == 'y'){
            foreach ($worker_invoices as $invoice){
                $salary += Common::getRepairs($invoice);
            }
            $invoices = Invoice::where("worker_id", '!=', $worker->id)
                    ->where('repair_type', 'invoice')
                    ->where("form_date", ">", date('Y-m-d H:i:s', strtotime($start_date)))
                    ->where("form_date", "<=", date('Y-m-d H:i:s', strtotime($end_date." 23:59:59")))
                    ->get();
            foreach ($invoices as $invoice){
                $salary += Common::getRepairs($invoice) / 2;
            }
        } else {
            foreach ($worker_invoices as $invoice){
                $salary += Common::getRepairs($invoice) / 2;
            }
        }
        return round($salary, 2);
    }
    
    static public function getPartPartsExpenses($start_date, $end_date) {
        $total_p = 0;
        $total_op = 0;
        $invoices  = Invoice::when($start_date, function($query) use ($start_date){
                        return $query->where("form_date", ">", date('Y-m-d H:i:s', strtotime($start_date)));
                    })
                ->when($end_date, function($query) use ($end_date){
                        return $query->where("form_date", "<=", date('Y-m-d H:i:s', strtotime($end_date." 23:59:59")));
                    })
                ->get();
        foreach ($invoices as $invoice) {
            foreach ($invoice->bills as $bill) {
                foreach ($bill->bill_details as $detail) {
                    $total_p += $detail->quantity * $detail->extend;
                }
            }
            foreach ($invoice->parts as $part){
                $total_op += $part->quantity * $part->extend;
            }
        }
        return [
            "total_p" => round($total_p, 2),
            "total_op" => round($total_op, 2),
        ];
    }
    static public function cantS($date){
        $starDate = new \DateTime($date.'-01');
        $lastday = date('t',strtotime($date));
        $endDate = new \DateTime($date.'-'.$lastday);
        $cant = 0;
        while( $starDate <= $endDate){
            if($starDate->format('l') == 'Saturday'){
               $cant++;
            }
            $starDate->modify("+1 days");
        }
        return $cant;
    }
    static function _getBalance($start_date, $end_date){
        $invoices  = Invoice::where('repair_type', 'invoice')
                ->when($start_date, function($query) use ($start_date){
                        return $query->where("pay_date", ">", date('Y-m-d H:i:s', strtotime($start_date)));
                    })
                ->when($end_date, function($query) use ($end_date){
                        return $query->where("pay_date", "<=", date('Y-m-d H:i:s', strtotime($end_date." 23:59:59")));
                    })
                ->get();
        $tax = Setting::where("key", 'tax')->firstOrFail();
        $trnsaction_fee = Setting::where("key", 'transaction_fee')->firstOrFail();
        $data = [
            'cash' => [
                'balance' => 0,
                'sub' => 0
            ],
            'check' => [
                'balance' => 0,
                'sub' => 0
            ],
            'debit' => [
                'balance' => 0,
                'sub' => 0
            ],
            'credit' => [
                'balance' => 0,
                'sub' => 0
            ]
        ];
        foreach ($invoices as $invoice) {
            switch ($invoice->payment_method){
                case 'cash':
                    $sub = Common::getSubTotal($invoice);
                    $tax_cal = round($sub * $tax->value / 100,2);
                    $data['cash']['balance'] += round($sub + $tax_cal,2);
                    $data['cash']['sub'] += round($sub,2);
                    break;
                case 'check':
                    $balance = Common::getSubTotal($invoice);
                    $data['check']['balance'] += $balance;
                    $data['check']['sub'] += $balance;
                    break;
                case 'debit':
                    $sub = Common::getSubTotal($invoice);
                    $tax_cal = round($sub * $tax->value / 100,2);
                    $tf = round(($sub + $tax_cal) * $trnsaction_fee->value / 100,2);
                    $data['debit']['balance'] += round($sub + $tax_cal,2);
                    $data['debit']['sub'] += round($sub - $tf,2);
                    break;
                case 'credit':
                    $sub = Common::getSubTotal($invoice);
                    $tax_cal = round($sub * $tax->value / 100,2);
                    $tf = round(($sub + $tax_cal) * $trnsaction_fee->value / 100,2);
                    $data['credit']['balance'] += round($sub + $tax_cal,2);
                    $data['credit']['sub'] += round($sub - $tf,2);
                    break;
            }
        }
        return $data;
    }
    static function getBalance($start_date, $end_date){
        $invoices  = Invoice::where('repair_type', 'invoice')
                ->when($start_date, function($query) use ($start_date){
                        return $query->where("pay_date", ">", date('Y-m-d H:i:s', strtotime($start_date)));
                    })
                ->when($end_date, function($query) use ($end_date){
                        return $query->where("pay_date", "<=", date('Y-m-d H:i:s', strtotime($end_date." 23:59:59")));
                    })
                ->get();
        $tax = Setting::where("key", 'tax')->firstOrFail();
        $trnsaction_fee = Setting::where("key", 'transaction_fee')->firstOrFail();
        $data = [
            'balance' => 0,
            'sub' => 0,
            'transaction_fee' => 0,
            'tax' => 0
        ];
        foreach ($invoices as $invoice) {
            switch ($invoice->payment_method){
                case 'cash':
                    $sub = Common::getSubTotal($invoice);
                    $tax_cal = round($sub * $tax->value / 100,2);
                    $data['balance'] += round($sub + $tax_cal,2);
                    $data['sub'] += round($sub,2);
                    $data['tax'] += $tax_cal;
                    break;
                case 'check':
                    $balance = Common::getSubTotal($invoice);
                    $data['balance'] += $balance;
                    $data['sub'] += $balance;
                    break;
                case 'debit':
                    $sub = Common::getSubTotal($invoice);
                    $tax_cal = round($sub * $tax->value / 100,2);
                    $tf = round(($sub + $tax_cal) * $trnsaction_fee->value / 100,2);
                    $data['balance'] += round($sub + $tax_cal,2);
                    $data['sub'] += round($sub - $tf,2);
                    $data['tax'] += $tax_cal;
                    $data['transaction_fee'] += $tf;
                    break;
                case 'credit':
                    $sub = Common::getSubTotal($invoice);
                    $tax_cal = round($sub * $tax->value / 100,2);
                    $tf = round(($sub + $tax_cal) * $trnsaction_fee->value / 100,2);
                    $data['balance'] += round($sub + $tax_cal,2);
                    $data['sub'] += round($sub - $tf,2);
                    $data['tax'] += $tax_cal;
                    $data['transaction_fee'] += $tf;
                    break;
            }
        }
        return $data;
    }
}


