<?php

namespace App\Http\Controllers;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;
use App\Image;

class ImageController extends Controller
{
    public function getUpload(Request $request)
    {
        return view('images.index', [
            'resource' => $request->get('resource'),
            'resource_id' => $request->get('resource_id'),
            ]);
    }
    public function all(Request $request){
        $images = Image::where([
            'resource' => $request->get('resource'),
            'resource_id' => $request->get('resource_id'),
            ])->get();
        $data = [];
        foreach ($images as $image) {
            $data[] = [
                'AttachmentID' => $image->file,
                'FileName' => '/images/'.$image->file,
                'Path' => '/images/'.$image->file,
                'select' => false,
            ];
        }
        return json_encode(["Data" => $data]);
        //return '{"Data":[{"AttachmentID":"1.jpg","FileName":"/images/1.jpg","Path":"/images/1.jpg"},{"AttachmentID":"2.jpg","FileName":"/images/2.jpg","Path":"/images/2.jpg"}]}';
    }
    public function postUpload(Request $request)
    {
        $imageName = $request->get('resource')."-".$request->get('resource_id').'-'.$request->file->getClientOriginalName();
        if($request->file->move(public_path('images'), $imageName)){
            $image = new Image;
            $image->resource = $request->get('resource');
            $image->resource_id = $request->get('resource_id');
            $image->file = $imageName;
            $image->save();
        }
        
        return response()->json(['success'=>$imageName]);

    }

    public function deleteUpload(Request $request)
    {
        $filename = $request->get('id');
        if(!$filename)
        {
            return 0;
        }
        if(strpos($filename, $request->get('resource')) === false) {
            $path = $request->get('resource')."-".$request->get('resource_id').'-'.$filename;
        }
        else {
            $path = $filename;
        }
        
        if(file_exists(public_path('images/').$path)) unlink(public_path('images/').$path);
        $image = Image::where([
            'resource' => $request->get('resource'),
            'resource_id' => $request->get('resource_id'),
            'file' => $path
            ])->first();
        if($image) $image->delete(); 
        return 1;
    }
}