<?php

namespace App\Http\Controllers;
use App\Invoice;
use App\Libraries\Common;
use App\Setting;
use Illuminate\Http\Request;

class FunctionsController extends Controller
{
    public function setPayDate(){
        Invoice::chunk(100,function($invoices){
            foreach ($invoices as $invoice) {
                if($invoice->status == 'paid' && !$invoice->pay_date) {
                    print_r($invoice->id.", ");
                    $invoice->pay_date = $invoice->form_date;
                    $invoice->save();
                }
            }
        });
        print_r("DONE!...");
    }
    
    public function setTotal(){
        Invoice::chunk(100,function($invoices){
            $tax = Setting::where("key", 'tax')->firstOrFail();
            foreach ($invoices as $invoice) {
                $sub_total = Common::getSubTotal($invoice);
                $tax_cal = $sub_total * $tax->value / 100;
                if($invoice->payment_method == "check") $total = $sub_total;
                else $total = round($sub_total + $tax_cal,2);
                $invoice->total = $total;
                $invoice->save();
            }
        });
        print_r("DONE!...");
    }
}
