<?php

namespace App\Http\Controllers\Api;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Worker;

class WorkersController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $per_page = 25;
        if(!empty($request->get("per_page"))) $per_page =  $request->get("per_page");
        $data = Worker::where("workers.deleted", 0)
                ->when($request->get("name"), function($query) use ($request){
                        return $query->where("name", "like", "%".$request->get("name")."%");
                    })
                ->when($request->get("tax"), function($query) use ($request){
                        return $query->where("tax", "like", "%".$request->get("tax")."%");
                    })
                ->orderBy('id','DESC')
                ->paginate($per_page);
        return $data;
    }
    public function getAll(){
        $workers = Worker::where("workers.deleted", 0)->get();
        return $workers;
    }
    public function getAllWithTax(){
        $workers = Worker::where("pay_tax", 1)->where("workers.deleted", 0)->get();
        return $workers;
    }
    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validate($request, [
            "name" => 'required',
            "tax" => 'required|numeric',
            "pay_tax" => 'required',
        ]);
        Worker::create($request->all());
        return;
    }
    public function show($id)
    {
        $data = Worker::findOrFail($id);
        return $data;
    }
    public function manager()
    {
        $data = Worker::where("is_main", 'y')->firstOrFail();
        return $data;
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $this->validate($request, [
            "name" => 'required',
            "tax" => 'required|numeric',
            "pay_tax" => 'required',
        ]);
        Worker::find($id)->update($request->all());
        return;
    }
    public function sign(Request $request)
    {
        $data = Worker::findOrFail($request->get('id'));
        $data->signature = $request->get('signature');
        $data->save();
        return;
    }
    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $data = Worker::findOrFail($id);
        $data->deleted = 1;
        $data->save();
        //$data->delete();
    }
}
