<?php

namespace App\Http\Controllers\Api;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Hash;
use Validator;
use Illuminate\Http\Exceptions\HttpResponseException;

class UserController extends Controller
{
    public function __construct()
    {
    }
    public function getAuthUser(){
        return Auth::user();
    }
    public function changePassword(Request $request){
      if (!(Hash::check($request->get('password'), Auth::user()->password))) {
            // The passwords matches
            //return redirect()->back()->with(["errors" => ["Your current password does not matches with the password you provided. Please try again."]]);
            throw new HttpResponseException(response()->json(["errors" => ["Your current password does not matches with the password you provided. Please try again."]], 422));
        }
 
        if(strcmp($request->get('password'), $request->get('new_password')) == 0){
            //Current password and new password are same
            //return redirect()->back()->with(["errors" => ["New Password cannot be same as your current password. Please choose a different password."]]);
            throw new HttpResponseException(response()->json(["errors" => ["New Password cannot be same as your current password. Please choose a different password."]], 422));
        }
 
        $this->validate($request, [
            'password' => 'required',
            'new_password' => 'required|string|min:6',
            'confirm_new_password' => 'required|same:new_password'
        ]);
 
        //Change Password
        $user = Auth::user();
        $user->password = bcrypt($request->get('new_password'));
        $user->save();
        return;
    }
}
