<?php

namespace App\Http\Controllers\Api;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Invoice;
use App\Setting;
use App\Worker;
use App\Libraries\Common;

class ReportsController extends Controller
{
    public function getBalance(Request $request){
        $data = Common::_getBalance($request->get("from"), $request->get("to"));
        return $data;
    }
    public function getBalanceByMethodsAndTotal(Request $request){
        
        $invoices  = Invoice::where('repair_type', 'invoice')
                ->when($request->get("method"), function($query) use ($request){
                        return $query->where("payment_method",$request->get("method"));
                    })
                ->when($request->get("from"), function($query) use ($request){
                        return $query->where("pay_date", ">=", date('Y-m-d H:i:s', strtotime($request->get("from"))));
                    })
                ->when($request->get("to"), function($query) use ($request){
                        return $query->where("pay_date", "<=", date('Y-m-d H:i:s', strtotime($request->get("to")." 23:59:59")));
                    })
                    ->orderby('pay_date', 'ASC')
                 ->get();
               
        $tax = Setting::where("key", 'tax')->firstOrFail();
        $trnsaction_fee = Setting::where("key", 'transaction_fee')->firstOrFail();
        $sub_total = 0;
        $balance_total = 0;
        foreach ($invoices as $invoice) {
            $sub = Common::getSubTotal($invoice);
            $tax_cal = ($sub * $tax->value / 100);
            $sub_total += round($sub,2);
            $balance_total += round($sub + $tax_cal,2);
        }
        return [
            'sub_total' => $sub_total,
            'balance_total' => $balance_total,
        ];
    }
    public function getBalanceByMethods(Request $request){
        $per_page = 25;
        if(!empty($request->get("per_page"))) $per_page =  $request->get("per_page");
        
        $invoices  = Invoice::where('repair_type', 'invoice')
                ->when($request->get("method"), function($query) use ($request){
                        return $query->where("payment_method",$request->get("method"));
                    })
                ->when($request->get("from"), function($query) use ($request){
                        return $query->where("pay_date", ">=", date('Y-m-d H:i:s', strtotime($request->get("from"))));
                    })
                ->when($request->get("to"), function($query) use ($request){
                        return $query->where("pay_date", "<=", date('Y-m-d H:i:s', strtotime($request->get("to")." 23:59:59")));
                    })
                    ->orderby('pay_date', 'ASC')
                 ->paginate($per_page);
               
        $tax = Setting::where("key", 'tax')->firstOrFail();
        $trnsaction_fee = Setting::where("key", 'transaction_fee')->firstOrFail();
        $data = [];
        $sub_total = 0;
        $balance_total = 0;
        foreach ($invoices as $invoice) {
            $sub = Common::getSubTotal($invoice);
            $tax_cal = ($sub * $tax->value / 100);
            $data[] = [
                'invoice' => $invoice->invoice_number,
                'client' => $invoice->client->name,
                'date' => $invoice->pay_date,
                'sub' => round($sub,2),
                'balance' => round($sub + $tax_cal,2),
            ];
            $sub_total += round($sub,2);
            $balance_total += round($sub + $tax_cal,2);
        }
        return [
            'data' => $data,
            'sub_total' => $sub_total,
            'balance_total' => $balance_total,
            'original_data' => $invoices
        ];
    }
    public function getWorkersSalary(Request $request){
        $per_page = 25;
        if(!empty($request->get("per_page"))) $per_page =  $request->get("per_page");
        $workers = Worker::when($request->get("worker"), function($query) use ($request){
                        return $query->where("id", $request->get("worker"));
                    })
                    ->paginate($per_page);
        $data = [
            'workers' => [],
            'totals' => 0
        ];
        foreach ($workers as $worker) {
            $salary = Common::getWorkerSalary($worker, $request->get('from'), $request->get('to'));
            $data['workers'][] = [
                'worker' => $worker->name,
                'salary' => $salary
            ]; 
        }
        $data['original_data'] = $workers;
        return $data;
    } 
    public function getPartsExpenses(Request $request){
        $invoices  = Invoice::where('repair_type', 'invoice')
                ->when($request->get("from"), function($query) use ($request){
                        return $query->where("form_date", ">", date('Y-m-d H:i:s', strtotime($request->get("from"))));
                    })
                ->when($request->get("to"), function($query) use ($request){
                        return $query->where("form_date", "<=", date('Y-m-d H:i:s', strtotime($request->get("to")." 23:59:59")));
                    })
                ->get();
        $data = [
            'data' => [],
            'totals' => 0,
            'totals_income' => 0,
        ];
        foreach ($invoices as $invoice) {
            foreach ($invoice->parts as $part){
                $data['data'][] = [
                    'invoice' => $part->part->bill_id,
                    'provider' => $part->part->provider->name,
                    'type' => 'Part',
                    'quantity' => $part->quantity,
                    'extend' => $part->extend,
                    'price' => $part->price,
                    'total' => round($part->quantity * $part->extend, 2),
                    'total_income' => round($part->quantity * ($part->price - $part->extend), 2),
                ];
                $data['totals'] = $data['totals'] + round($part->quantity * $part->extend, 2);
                $data['totals_income'] = $data['totals_income'] + round($part->quantity * ($part->price - $part->extend), 2);
            }
            foreach ($invoice->bills as $bill) {
                $total = 0;
                $total_income = 0;
                foreach ($bill->bill_details as $detail) {
                    $total += $detail->quantity * $detail->extend;
                    $total_income += $detail->quantity * ($detail->price - $detail->extend);
                }
                $data['data'][] = [
                    'invoice' => $bill->inv_number,
                    'provider' => $bill->provider->name,
                    'type' => 'Bill',
                    'quantity' => '-',
                    'extend' => '-',
                    'price' => '-',
                    'total' => round($total, 2),
                    'total_income' => round($total_income, 2)
                ];
                $data['totals'] = $data['totals'] + round($total, 2);
                $data['totals_income'] = $data['totals_income'] + round($total_income, 2);
            }
        }
        return $data;
    }
    PUBLIC FUNCTION getIncomes(Request $request){
        
        $month = explode("/", $request->get('month'));
        $month = $month[1]."-".$month[0];
        
        $start_date = date('m',strtotime($month)).'/01/'.date('Y',strtotime($month));
        $end_date = date('m',strtotime($month))."/".date('t',strtotime($start_date))."/".date('Y',strtotime($month)); 
        
        $data= [];
        
        $balance = Common::_getBalance($start_date, $end_date);
        $total_balance = round($balance['cash']['sub'] + $balance['check']['sub'] + $balance['debit']['sub'] + $balance['credit']['sub'], 2);
        $data[] = [
            'index' => 0,
            'name' => '(Cash + Check + Debit + Credit)',
            'value' => $total_balance
        ];
        
        $rent = Setting::where("key", 'rent')->firstOrFail();
        $data[] = [
            'index' => 1,
            'name' => 'Rent',
            'value' => $rent->value
        ];
        
        $cant_s = Common::cantS(date("Y-m", strtotime($start_date)));
        $sum_workers_tax = 0; 
        $workers = Worker::where("pay_tax", 1)->get();
        foreach ($workers as $item){
            $sum_workers_tax += $item->tax * $cant_s;
        }
        $sum_workers_tax = round($sum_workers_tax,2);
        $data[] = [
            'index' => 2,
            'name' => 'Workers Taxes',
            'value' => $sum_workers_tax
        ];
        
        $workers = Worker::where("is_main", '!=', 'y')->get();
        $salary = 0;
        foreach ($workers as $worker) {
            $salary += Common::getWorkerSalary($worker, $start_date, $end_date);
        }
        $salary = round($salary, 2);
        $data[] = [
            'index' => 3,
            'name' => 'Workers Salary',
            'value' => $salary
        ];
        $total_parts = Common::getPartPartsExpenses($start_date, $end_date);
        $data[] = [
            'index' => 4,
            'name' => 'Part Extends',
            'value' => $total_parts['total_p']
        ];
        $data[] = [
            'index' => 5,
            'name' => 'Other Parts',
            'value' => $total_parts['total_op']
        ];
        $incomes = $total_balance - $rent->value - $sum_workers_tax - $salary - $total_parts['total_p'] - $total_parts['total_op'];
        $incomes = round($incomes, 2);
        $data[] = [
            'index' => 6,
            'name' => 'Personal Incomes',
            'value' => $incomes
        ];
        
        return $data;
    }
    
}
