<?php

namespace App\Http\Controllers\Api;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Payment;
use App\Invoice;
use App\BillDetail;
use App\Setting;
use App\Worker;
use Illuminate\Support\Facades\DB;
class RentController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $per_page = 30;
        if(!empty($request->get("per_page"))) $per_page =  $request->get("per_page");
        $data = Payment::orderBy('id','DESC')
                ->when($request->get("year"), function($query) use ($request){
                        return $query->where("year", $request->get("year"));
                    })
                ->when($request->get("month"), function($query) use ($request){
                        return $query->where("month", $request->get("month"));
                    })
                ->paginate($per_page);
        return $data;
    }
    public function lastPayment($id){
        $payment = Payment::findOrFail($id);
        $date = date("Y-m",strtotime($payment->year . "-" . $payment->month));
        $newdate = strtotime ( '-1 month' , strtotime($date)) ;
        $month = date ( 'n' , $newdate );
        $year = date ( 'Y' , $newdate );
        $last_payment = Payment::where("month", $month)->where("year",$year)->firstOrFail();
        return $last_payment;
    }
    public function cantS($date){
        $starDate = new \DateTime($date.'-01');
        $lastday = date('t',strtotime($date));
        $endDate = new \DateTime($date.'-'.$lastday);
        $cant = 0;
        while( $starDate <= $endDate){
            if($starDate->format('l') == 'Saturday'){
               $cant++;
            }
            $starDate->modify("+1 days");
        }
        return $cant;
    }
    public function getInvoices($id){
        $payment = Payment::findOrFail($id);
        $date = date("Y-m",strtotime($payment->year . "-" . $payment->month));
        $before_date = date("Y-m-t", strtotime ( '-1 month' , strtotime($payment->year . "-" . $payment->month)));
        $before_payment = Payment::where("year",date("Y", strtotime($before_date)))
                ->where("month",date("m", strtotime($before_date)))
                ->firstOrFail();
        $tax = Setting::where("key", 'tax')->firstOrFail();
        $trnsaction_fee = Setting::where("key", 'transaction_fee')->firstOrFail();
        /*$newdate = strtotime ( '-1 month' , strtotime($date)) ;
        $month = date ( 'n' , $newdate );
        $year = date ( 'Y' , $newdate );
        $last_payment = Payment::where("month", $month)->where("year",$year)->firstOrFail();*/
        $invoices = Invoice::where("pay_date", ">", $before_payment->inv_date)
                    ->where("pay_date", "<=", $payment->inv_date)
                    ->where("payment_method", "!=", "cash")
                    ->get();
        $results = [];
        foreach($invoices as $invoice){
            $amount = 0;
            $parts = [];
            foreach ($invoice->bills as $bill) {
                foreach ($bill->bill_details as $detail) {
                    $amount += $detail->quantity * $detail->price;
                }
            }
            foreach ($invoice->parts as $part){
                $amount += $part->quantity * $part->price;
            }
            foreach ($invoice->repairs as $repair){
                $amount += $repair->labor * $repair->time;
            }
            $amount += $invoice->sublet_other;
            $amount += $invoice->shop_supplies;
            $amount += $invoice->fees;
            if($invoice->payment_method == 'check') $balance = $amount;
            else $balance = $amount + ($amount * $tax->value / 100);
            if($invoice->payment_method == 'check') $balance_10 = round($balance,2);
            else $balance_10 = round($amount  - ($balance * $trnsaction_fee->value / 100),2) ;
            //else $balance_10 = round($balance * (100 - ($tax->value + $trnsaction_fee->value)) / 100,2);
            $results[] = [
                'invoice_number' => $invoice->invoice_number,
                'form_date' => $invoice->pay_date,
                'payment_method' => $invoice->payment_method,
                'subtotal' => $amount,
                'man' => $invoice->payment_method == 'check' ? $amount : round($amount - ($amount * $trnsaction_fee->value / 100)),
                'balance' => $balance,
                'balance_10' => $balance_10
            ];
        }
        return $results;
    }
    public function yearsPayment(){
        $years = Payment::select(DB::raw("distinct(payments.year)"))
                ->orderby('payments.year', 'ASC')
                ->get();
        return $years;
    }
    public function monthsPayment(){
        $months = Payment::select(DB::raw("distinct(payments.month)"))
                ->orderby('payments.month', 'ASC')
                ->get();
        return $months;
    }
    public function lastMonthPay(){
        
        $tax = Setting::where("key", 'tax')->firstOrFail();
        $rent = Setting::where("key", 'rent')->firstOrFail();
        $transaction_fee = Setting::where("key", 'transaction_fee')->firstOrFail();
        
        $last_month = Payment::orderby('year', 'DESC')->orderby('month', 'DESC')->firstOrFail();
        $month_to_pay = date("Y-m-t", strtotime ( '+1 month' , strtotime($last_month->year . "-" . $last_month->month)));
        $now = date("Y-m-d");
        $pay = false;
        if(strtotime($now) > strtotime($month_to_pay)) $pay = true;
        $invoices = Invoice::where("pay_date", ">", $last_month->inv_date)
                    ->where("pay_date", "<=", date('Y-m-d H:i:s', strtotime($month_to_pay." 23:59:59")))
                    ->where("payment_method", "!=", "cash")
                    ->get();
        $amount_invoices = 0;
        foreach($invoices as $invoice){
            $amount = 0;
            $parts = [];
            foreach ($invoice->bills as $bill) {
                foreach ($bill->bill_details as $detail) {
                    $amount += $detail->quantity * $detail->price;
                }
            }
            foreach ($invoice->parts as $part){
                $amount += $part->quantity * $part->price;
            }
            foreach ($invoice->repairs as $repair){
                $amount += $repair->labor * $repair->time;
            }
            $amount += $invoice->sublet_other;
            $amount += $invoice->shop_supplies;
            $amount += $invoice->fees;
            if($invoice->payment_method == 'check') $t = $amount;
            else {
                $taxa = $amount * $tax->value / 100;
                $trans = ($amount + $taxa) * $transaction_fee->value / 100;
                $t = round($amount - $trans, 2);
            }
            $amount_invoices += $t;
        }
        $cant_s = $this->cantS(date("Y-m", strtotime($month_to_pay)));
        $sum_workers_salary = 0; 
        $workers = Worker::where("pay_tax",1)->get();
        foreach ($workers as $item){
            $sum_workers_salary += $item->tax * $cant_s;
        }
        $total_to_pay = $rent->value + $sum_workers_salary;
        
        $result = [
            "pay" => $pay,
            'month_to_pay' => $month_to_pay,
            'last_month' => $last_month,
            'rent' => $rent->value,
            'workers_salary' => $sum_workers_salary,
            'total_to_pay' => $total_to_pay,
            'total_available' => $amount_invoices + $last_month->dc_remaining,
        ];
        return $result;
    }
    public function payRent(Request $request){
        $payment = new Payment;
        $month_to_pay = strtotime($request->get('month_to_pay'));
        $payment->year = date("Y", $month_to_pay);
        $payment->month = date("m", $month_to_pay);
        $payment->date = date("Y-m-d H:i:s");
        $payment->inv_date = date("Y-m-d H:i:s", strtotime($request->get('month_to_pay')." 23:59:59"));
        $payment->rent_val = $request->get('rent');
        $payment->workers_salary = $request->get('workers_salary');
        $payment->debit_credit = $request->get('total_available');
        if($request->get('total_available') > $request->get('total_to_pay')) {
            $payment->dc_remaining = $request->get('total_available') - $request->get('total_to_pay') - $request->get('discount_remaining');
            $payment->discount_remaining = $request->get('discount_remaining');
            $payment->excedent = $payment->dc_remaining;
            $payment->cash_paid = 0;
            $payment->pending_debt = 0;
            $payment->debt_was = 0;
        }
        else {
            $payment->dc_remaining = 0;
            $payment->excedent = 0;
            if($request->get('diff_type') == 'cash'){
                $payment->cash_paid = $request->get('total_to_pay') - $request->get('total_available');
                $payment->pending_debt = 0;
                $payment->debt_was = 0;
            }
            else {
                $payment->pending_debt = $request->get('total_to_pay') - $request->get('total_available');
                $payment->debt_was = $request->get('total_to_pay') - $request->get('total_available');;
                $payment->cash_paid = 0;
            }
        }
        $payment->save();
        return json_encode(["status" => true]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $payment = Payment::findOrFail($id);
        return $payment;
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $data = Payment::findOrFail($id);
        $data->delete();
    }
}
