<?php

namespace App\Http\Controllers\Api;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Provider;

class ProvidersController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $per_page = 25;
        if(!empty($request->get("per_page"))) $per_page =  $request->get("per_page");
        $data = Provider::where("providers.deleted", 0)
                ->when($request->get("name"), function($query) use ($request){
                        return $query->where("name", "like", "%".$request->get("name")."%");
                    })
                ->when($request->get("store"), function($query) use ($request){
                        return $query->where("store", "like", "%".$request->get("store")."%");
                    })
                ->when($request->get("address"), function($query) use ($request){
                        return $query->where("address", "like", "%".$request->get("address")."%");
                    })
                ->orderBy('id','DESC')
                ->paginate($per_page);
        return $data;
    }
    public function getAll(){
        $providers = Provider::where("providers.deleted", 0)->get();
        return $providers;
    }
    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validate($request, [
            "name" => 'required',
            "store" => 'required',
            "address" => 'required',
        ]);
        Provider::create($request->all());
        return;
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $data = Provider::findOrFail($id);
        return $data;
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $this->validate($request, [
            "name" => 'required',
            "store" => 'required',
            "address" => 'required',
        ]);
        Provider::find($id)->update($request->all());
        return;
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $data = Provider::findOrFail($id);
        $data->deleted = 1;
        $data->save();
        //$data->delete();
    }
}
