<?php

namespace App\Http\Controllers\Api;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Bill;
use App\BillDetail;
use App\Part;
use App\BillPart;
use App\InvoiceBill;

class ProviderBillsController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $per_page = 25;
       
        if(!empty($request->get("per_page"))) $per_page =  $request->get("per_page");
        $data = Bill::orderBy('id','DESC')
                ->when($request->get("provider"), function($query) use ($request){
                        return $query->join('providers', 'bills.provider_id', '=', 'providers.id')
                                ->where("providers.id", $request->get("provider"));
                    })
                ->when($request->get("store"), function($query) use ($request){
                        return $query->join('providers', 'bills.provider_id', '=', 'providers.id')
                                ->where("providers.store", "like", "%".$request->get("store")."%");
                    })
                ->when($request->get("form_date"), function($query) use ($request){
                        return $query->where("bills.form_date", "like", "%".$request->get("form_date")."%");
                    })
                ->when($request->get("inv_number"), function($query) use ($request){
                        return $query->where("bills.inv_number", "like", "%".$request->get("inv_number")."%");
                    })
                ->when($request->get("status"), function($query) use ($request){
                        return $query->where("bills.status", "=", $request->get("status"));
                    })
                ->when($request->get("in_use"), function($query) use ($request){
                        return $query->where("bills.in_use", "=", $request->get("in_use"));
                    })
                ->with(['provider','bill_details', 'bill_parts', 'invoices'])
                ->select("bills.*")
                ->paginate($per_page);
        return $data;
    }
    public function getProviderBillsNotUse(Request $request)
    {
        $provider_id = $request->get("provider_id");
        
       // $bill = Bill::fromQuery("select bills.* from bills where provider_id = $provider_id and id not in (select bill_id from invoice_bills) and (select count(bill_details.id) from bill_details where bills.id = bill_details.bill_id) > 0");
       $bill= Bill::fromQuery("SELECT b.*
                                FROM bills b
                                INNER JOIN bill_details bd ON b.id = bd.bill_id
                                LEFT JOIN invoice_bills ib ON b.id = ib.bill_id
                                WHERE b.provider_id =  $provider_id
                                AND ib.bill_id IS NULL
                                GROUP BY b.id");
        
        return $bill;
    }
    public function show($id)
    {
        $bill = Bill::with(['provider','bill_details', 'bill_parts'])->findOrFail($id);
        return $bill;
    }
    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validate($request, [
            "provider_id" => 'required',
            "form_date" => 'required',
            "inv_number" => 'required',
            //"in_use" => 'required',
            "status" => 'required',
        ]);
        if($bill = Bill::create($request->all())){
            $bill_details = $request->get('bill_details');
            foreach ($bill_details as $item) {
                $part = new BillDetail;
                $part->bill_id = $bill->id;
                $part->name = $item['name'];
                $part->part_number = $item['part_number'];
                $part->quantity = $item['quantity'];
                $part->description = $item['description'];
                $part->extend = $item['extend'];
                $part->price = $item['price'];
                //$part->part_id = $item['part_id'];
                $part->warranty = $item['warranty'];
                $part->warranty_client = $item['warranty_client'];
                $part->save();
                /*if($part->part_id) {
                    $part_stock = Part::find($part->part_id);
                    $part_stock->quantity = $part_stock->quantity + $part->quantity;
                    $part_stock->save();
                }*/
            }
            $bill_parts = $request->get('bill_parts');
            foreach ($bill_parts as $item) {
                $part = new BillPart;
                $part->bill_id = $bill->id;
                $part->name = $item['name'];
                $part->part_number = $item['part_number'];
                $part->quantity = $item['quantity'];
                $part->description = $item['description'];
                $part->extend = $item['extend'];
                $part->price = $item['price'];
                $part->part_id = $item['part_id'];
                $part->warranty = $item['warranty'];
                //$part->warranty_client = $item['warranty_client'];
                $part->save();
                if($part->part_id) {
                    $part_stock = Part::find($part->part_id);
                    $part_stock->quantity = $part_stock->quantity + $part->quantity;
                    $part_stock->save();
                }
            }
        }
        return;
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $this->validate($request, [
            "provider_id" => 'required',
            "form_date" => 'required',
            "inv_number" => 'required',
            //"in_use" => 'required',
            "status" => 'required',
        ]);
        Bill::find($id)->update($request->all());
        $bill = Bill::find($id);
        BillDetail::where("bill_id", $id)->delete();
        foreach ($bill->bill_parts as $item) {
            if($item->part_id) {
                $part_stock = Part::find($item->part_id);
                if($part_stock->quantity - $item->quantity >= 0) {
                    $part_stock->quantity = $part_stock->quantity - $item->quantity;
                    $part_stock->save();
                }
            }
            $item->delete();
        }
        $bill_details = $request->get('bill_details');
        foreach ($bill_details as $item) {
            $part = new BillDetail;
            $part->bill_id = $id;
            $part->name = $item['name'];
            $part->part_number = $item['part_number'];
            $part->quantity = $item['quantity'];
            $part->description = $item['description'];
            $part->extend = $item['extend'];
            $part->price = $item['price'];
            //$part->part_id = $item['part_id'];
            $part->warranty = $item['warranty'];
            $part->warranty_client = $item['warranty_client'];
            $part->save();
        }
        $bill_parts = $request->get('bill_parts');
        foreach ($bill_parts as $item) {
            $part = new BillPart;
            $part->bill_id = $id;
            $part->name = $item['name'];
            $part->part_number = $item['part_number'];
            $part->quantity = $item['quantity'];
            $part->description = $item['description'];
            $part->extend = $item['extend'];
            $part->price = $item['price'];
            $part->part_id = $item['part_id'];
            $part->warranty = $item['warranty'];
            $part->save();
            if($part->part_id) {
                $part_stock = Part::find($part->part_id);
                $part_stock->quantity = $part_stock->quantity + $part->quantity;
                $part_stock->save();
            }
        }
        return;
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $data = Bill::findOrFail($id);
        foreach ($data->bill_parts as $item) {
            if($item->part_id) {
                $part_stock = Part::find($item->part_id);
                if($part_stock->quantity - $item->quantity >= 0) {
                    $part_stock->quantity = $part_stock->quantity - $item->quantity;
                    $part_stock->save();
                }
            }
            $item->delete();
        }
        if($data->delete()){
            BillDetail::where("bill_id", $id)->delete();
            
        }
    }
}
