<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Bill extends Model
{
    protected $fillable = ['provider_id', "form_date","inv_number","in_use", "status"];
    public function provider()
    {
        return $this->belongsTo(Provider::class);
    }
    public function bill_details()
    {
        return $this->hasMany(BillDetail::class);
    }
    public function bill_parts()
    {
        return $this->hasMany(BillPart::class);
    }
    public function invoice_bill()
    {
        return $this->hasMany(InvoiceBill::class);
    }
    public function invoices()
    {
        return $this->belongsToMany(Invoice::class, "invoice_bills","bill_id", "invoice_id");
    }
}
