<?php
use App\Libraries\Common;

?>
<!DOCTYPE html>
<!--[if IE 8]> <html lang="en" class="ie8 no-js"> <![endif]-->
<!--[if IE 9]> <html lang="en" class="ie9 no-js"> <![endif]-->
<!--[if !IE]><!-->
<html lang="{{ app()->getLocale() }}">
<!--<![endif]-->
<!-- BEGIN HEAD -->

<head>
    <meta charset="utf-8" />
    <!-- CSRF Token -->
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <title>{{ config('app.name', 'Fonts Wizard Preview') }}</title>
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta content="width=device-width, initial-scale=1" name="viewport" />
    <meta content="{{ config('app.name', 'Fonts Wizard Preview') }}" name="description" />
    <meta content="" name="author" />


    <link href="{{ asset('assets/global/plugins/bootstrap/css/bootstrap.min.css') }}" rel="stylesheet"
        type="text/css" />
    <link href="{{ asset('assets/global/plugins/bootstrap-switch/css/bootstrap-switch.min.css') }}" rel="stylesheet"
        type="text/css" />
    <link href="{{ asset('assets/layouts/layout2/css/custom.min.css') }}" rel="stylesheet" type="text/css" />
    <!-- BEGIN GLOBAL MANDATORY STYLES -->
    <!--<link href="http://fonts.googleapis.com/css?family=Open+Sans:400,300,600,700&subset=all" rel="stylesheet" type="text/css" />-->

    <!-- END HEAD -->
    <style id="dinamic" type="text/css"></style>
    <style>
        .boxok {
            box-shadow: rgba(0, 0, 0, 0.25) 0px 54px 55px, rgba(0, 0, 0, 0.12) 0px -12px 30px, rgba(0, 0, 0, 0.12) 0px 4px 6px, rgba(0, 0, 0, 0.17) 0px 12px 13px, rgba(0, 0, 0, 0.09) 0px -3px 5px;
            border-radius: 15px 0px 15px 0px;
            box-shadow: 2px 2px 5px #999999;
        }

        @media only screen and (min-width: 360px) and (max-width: 768px) {

            .stage,
            .stage1 {
                height: 200px !important;
            }
        }

        @media only screen and (min-width: 800px) and (max-width: 1090px) {

            .stage,
            .stage1 {
                height: 300px !important;
            }
        }

        a {
            color: #28f;
            text-decoration: none;
        }

        a:hover,
        a:focus {
            color: #0062d5;
        }

        a:active {
            color: #003f88;
        }

        main {
            margin: 0 auto;
            max-width: auto;
            padding: 1em;
        }

        .article-list__page {
            border-top: 1px solid #ddd;
            clear: both;
            counter-increment: page;
            padding-bottom: 3em;
            position: relative;
        }

        .article-list__page:before {
            background-color: #ddd;
            display: inline-block;
            content: counter(page);
            color: #888;
            padding: 0.25em 0.5em;
            position: absolute;
            left: calc(50% - .75em);
            top: -0.75em;
            vertical-align: middle;
            z-index: 1;
        }

        .article-list__item {
            background-color: #eee;
            /*float: left;*/
            height: auto;
            /*max-width: 50%;*/
            /*opacity: 0.75;
  transform: scale(0.8);*/
            transition: opacity 0.2s, transform 0.2s;

        }

        .article-list__item:hover {
            opacity: 1;
            transform: scale(1);
        }

        .article-list__item__image {
            display: block;
            height: auto;
            margin: 0;
            opacity: 1;
            transition: opacity 0.2s;
            width: 100%;
        }

        .article-list__item__image--loading {
            opacity: 0;
        }

        .article-list__pagination {
            background-color: #222;
            box-shadow: 0 0 1em rgba(0, 0, 0, 0.25);
            display: block;
            bottom: 0;
            left: 0;
            list-style-type: none;
            margin: 0;
            padding: 0.5em;
            position: fixed;
            right: 0;
            text-align: center;
            transform: translateY(0);
            transition: transform 0.2s;
            z-index: 10;
        }

        .article-list__pagination--inactive {
            transform: translateY(100%);
        }

        .article-list__pagination__item {
            display: inline-block;
            margin: 0 1em;
        }

        .article-list__pagination__item a {
            color: #888;
            text-decoration: none;
        }

        .article-list__pagination__item a:hover,
        .article-list__pagination__item a:focus {
            color: #aeaeae;
        }

        .article-list__pagination__item a:active {
            color: #d5d5d5;
        }
    </style>

<body class="loginbg" style="margin: 10px">
    <?php
    
    ?>
    <div class="container-fluid">
        <div class="row">
            <div class="col-xs-12 col-sm-12" style="text-align: center;">
                <img src="/img/logo-avi.png" alt="" style="width: 100px; margin-bottom:10px;">
            </div>
        </div>
        <div class="row">
            <div class="col-xs-12 col-sm-12" style="text-align: center;">
                <div style="font-weight: 600; font-size:18px;">Font Wizard Pro Preview</div>
                <img src="" alt="">
            </div>
        </div>
        <main>


            <div class="article-list" id="article-list"></div>
            <ul class="article-list__pagination article-list__pagination--inactive" id="article-list-pagination"></ul>
        </main>



    </div>
    <script src="{{ asset('assets/global/plugins/admin/js/vendor/jquery-1.11.2.min.js') }}"></script>
    <script>
        function getPageId(n) {
            return 'article-page-' + n;
        }

        function getDocumentHeight() {
            const body = document.body;
            const html = document.documentElement;

            return Math.max(
                body.scrollHeight, body.offsetHeight,
                html.clientHeight, html.scrollHeight, html.offsetHeight
            );
        };

        function getScrollTop() {
            return (window.pageYOffset !== undefined) ? window.pageYOffset : (document.documentElement || document.body
                .parentNode || document.body).scrollTop;
        }


        function getArticle(id) {
            var color_id = '<?php echo $color; ?>';
            var texto = '<?php echo $order->design_name; ?>';
            var base = "{{ url('/') }}";
            var urlv = base + "/" + "part" + "/" + texto + "/" + id + "/" + id + "/" + color_id;
            var token = '{{ csrf_token() }}'; // ó $("#token").val() si lo tienes en una etiqueta html.
            const article = document.createElement('article');
            const elementx = document.createElement('div');
            var result = "";
            var data = {};
            $.ajax({
                type: "get",
                url: urlv,
                data: data,
                success: function(msg) {
                    var obj = jQuery.parseJSON(msg);
                    console.log(obj.htmlcode)
                    elementx.innerHTML = obj.htmlcode;
                    $("#dinamic").append(obj.csscode);
                    article.className = 'article-list__item';
                    article.appendChild(elementx);

                },
                error: function(result) {
                    console.log($result)
                }
            });



            return article;
        }

        function getArticlePage(page, articlesPerPage = 60) {
            var count = 0;
            var id = 0;
            const total = 60;
            const pageElement = document.createElement('div');
            pageElement.id = getPageId(page);
            pageElement.className = 'article-list__page row';
            var factor = page - 1;
            while (articlesPerPage--) {
                count++;
                id = (factor * total) + count;
                //console.log(id)
                // console.log(factor)
                pageElement.appendChild(getArticle(id));
            }

            return pageElement;
        }

        function addPaginationPage(page) {
            const pageLink = document.createElement('a');
            pageLink.href = '#' + getPageId(page);
            pageLink.innerHTML = page;

            const listItem = document.createElement('li');
            listItem.className = 'article-list__pagination__item';
            listItem.appendChild(pageLink);

            articleListPagination.appendChild(listItem);

            if (page === 2) {
                articleListPagination.classList.remove('article-list__pagination--inactive');
            }
        }

        function fetchPage(page) {
            articleList.appendChild(getArticlePage(page));
        }

        function addPage(page) {
            fetchPage(page);
            addPaginationPage(page);
        }

        const articleList = document.getElementById('article-list');
        const articleListPagination = document.getElementById('article-list-pagination');
        let page = 0;

        addPage(++page);

        window.onscroll = function() {
            var total = '<?php echo $total; ?>';
            /* console.log(getScrollTop() +2);
             console.log(getDocumentHeight() - window.innerHeight);*/
            if ((getScrollTop() + 2) < getDocumentHeight() - window.innerHeight) return;
            if (page < total / 60) {
                addPage(++page);
            }

        };
    </script>
</body>

</html>
