<?php
use App\Libraries\Common;
?>
<!DOCTYPE html>
<!--[if IE 8]> <html lang="en" class="ie8 no-js"> <![endif]-->
<!--[if IE 9]> <html lang="en" class="ie9 no-js"> <![endif]-->
<!--[if !IE]><!-->
<html lang="{{ app()->getLocale() }}">
<!--<![endif]-->
<!-- BEGIN HEAD -->

<head>
    <meta charset="utf-8" />
    <!-- CSRF Token -->
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <title>{{ config('app.name', 'Laravel') }}</title>
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta content="width=device-width, initial-scale=1" name="viewport" />
    <meta content="{{ config('app.name', 'Laravel') }}" name="description" />
    <meta content="" name="author" />
    <!-- BEGIN GLOBAL MANDATORY STYLES -->
    <!--<link href="http://fonts.googleapis.com/css?family=Open+Sans:400,300,600,700&subset=all" rel="stylesheet" type="text/css" />-->
    <link href="{{ asset('assets/global/plugins/bootstrap/css/bootstrap.min.css') }}" rel="stylesheet"
        type="text/css" />
    <link href="{{ asset('css/app.css') }}" rel="stylesheet" type="text/css" />
    <!-- END HEAD -->

<body class="pdf">
    <div class="page-header">
        <table style="width: 100%">
            <tr>
                <td style="width: 50%; text-align: left; line-height: 50px">
                    <img src="{{ asset('./img/logo-avi.png') }}" style="width: 120px;" />
                </td>
                <td style="width: 50%; text-align: right; line-height: 50px">
                    <h3 style="padding: 0; margin: 0">[{{ date('d M Y') }}]</h3>
                </td>
            </tr>
        </table>
    </div>
    <div style="overflow: hidden">
        <?php if (!empty($owner)) :?><p style="float: left; padding: 10px 20px;"><b>Owner:</b> <?php echo $owner->name; ?></p>
        <?php endif?>
        <?php if (!empty($pieceType)) :?><p style="float: left; padding: 10px 20px;"><b>Piece</b> <?php echo $pieceType->name; ?></p>
        <?php endif?>
        <?php if (!empty($status)) :?><p style="float: left; padding: 10px 20px;"><b>Status:</b> <?php echo $status; ?></p>
        <?php endif?>
        <?php if (!empty($from)) :?><p style="float: left; padding: 10px 20px;"><b>From:</b> <?php echo date('d M Y', strtotime($from)); ?></p>
        <?php endif?>
        <?php if (!empty($to)) :?><p style="float: left; padding: 10px 20px;"><b>To:</b> <?php echo date('d M Y', strtotime($to)); ?></p>
        <?php endif?>
    </div>
    <table class="table table-bordered table-striped table-condensed flip-content" style="font-size: 16px;">
        <thead>
            <tr>
                <th>REF</th>
                <th>Description</th>
                <th>Wax</th>
                <th>Gold</th>
                <th>Diamonds</th>
                <th>Polish</th>
                <th>Laser</th>
                <th>Setting</th>
                <th>Total</th>
            </tr>
        </thead>
        <tbody>
            <?php
            $tTotal = 0;
            $tWax = 0;
            $tGold = 0;
            $tPolish = 0;
            $tLaser = 0;
            $tDiamonds = 0;
            $tSetting = 0;
            ?>
            <?php foreach ($data as $item) :?>
            <?php
            $total = 0;
            $total += $item->wax;
            $total += $item->gold;
            $total += $item->polish;
            $total += $item->laser;
            $total += $item->diamonds;
            $total += $item->setting;
            
            $tWax += $item->wax;
            $tGold += $item->gold;
            $tPolish += $item->polish;
            $tLaser += $item->laser;
            $tDiamonds += $item->diamonds;
            $tSetting += $item->setting;
            $tTotal += $total;
            ?>
            <tr style="page-break-inside: avoid;">
                <td><?php echo $item->ref; ?></td>
                <td><?php echo $item->description; ?></td>
                <td>$<?php echo number_format(round($item->wax), 2); ?></td>
                <td>$<?php echo number_format(round($item->gold), 2); ?></td>
                <td>$<?php echo number_format(round($item->diamonds), 2); ?></td>
                <td>$<?php echo number_format(round($item->polish), 2); ?></td>
                <td>$<?php echo number_format(round($item->laser), 2); ?></td>
                <td>$<?php echo number_format(round($item->setting), 2); ?></td>
                <td>$<?php echo number_format(round($total), 2); ?></td>
            </tr>
            <?php endforeach;?>
            <tr>
                <td colspan="2"><b>Total:</b></td>
                <td><b>$<?php echo number_format(round($tWax), 2); ?></b></td>
                <td><b>$<?php echo number_format(round($tGold), 2); ?></b></td>
                <td><b>$<?php echo number_format(round($tDiamonds), 2); ?></b></td>
                <td><b>$<?php echo number_format(round($tPolish), 2); ?></b></td>
                <td><b>$<?php echo number_format(round($tLaser), 2); ?></b></td>
                <td><b>$<?php echo number_format(round($tSetting), 2); ?></b></td>
                <td><b>$<?php echo number_format(round($tTotal), 2); ?></b></td>
            </tr>
        </tbody>
    </table>
</body>

</html>
