<?php

use App\Libraries\Common;

?>
<!DOCTYPE html>
<!--[if IE 8]> <html lang="en" class="ie8 no-js"> <![endif]-->
<!--[if IE 9]> <html lang="en" class="ie9 no-js"> <![endif]-->
<!--[if !IE]><!-->
<html lang="{{ app()->getLocale() }}">
<!--<![endif]-->
<!-- BEGIN HEAD -->

<head>
    <meta charset="utf-8" />
    <!-- CSRF Token -->
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <title>{{ config('app.name', 'Fonts Wizard Preview') }}</title>
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta content="minimum-scale=1.0, width=device-width, maximum-scale=1, user-scalable=no" name="viewport" />
    <meta content="{{ config('app.name', 'Fonts Wizard Preview') }}" name="description" />
    <meta content="" name="author" />


    <link href="{{ asset('assets/global/plugins/bootstrap/css/bootstrap.min.css') }}" rel="stylesheet"
        type="text/css" />
    <link href="{{ asset('assets/global/plugins/bootstrap-switch/css/bootstrap-switch.min.css') }}" rel="stylesheet"
        type="text/css" />
    <link href="{{ asset('assets/layouts/layout2/css/custom.min.css') }}" rel="stylesheet" type="text/css" />

    <!-- Custom Fonts -->
    <link rel="stylesheet"
        href="{{ asset('fonts/custom/stylesheet.css') }}?v={{ file_exists(public_path('fonts/custom/stylesheet.css')) ? filemtime(public_path('fonts/custom/stylesheet.css')) : time() }}">

    <!-- BEGIN GLOBAL MANDATORY STYLES -->
    <!--<link href="http://fonts.googleapis.com/css?family=Open+Sans:400,300,600,700&subset=all" rel="stylesheet" type="text/css" />-->

    <!-- END HEAD -->

</head>
<script src="https://unpkg.com/sweetalert/dist/sweetalert.min.js"></script>
<style id="dinamic" type="text/css"></style>
<style id="dinamic1" type="text/css"></style>
<style>
    /* Nuevo Sistema de Zoom - Desde Cero */
    .zoom-control-panel {
        background: transparent;
        padding: 20px;
        margin: 10px 0;
    }

    .zoom-info {
        text-align: center;
        margin-bottom: 20px;
    }

    .zoom-label {
        font-size: 16px;
        font-weight: 600;
        color: #333;
        margin-right: 8px;
    }

    .zoom-percentage {
        font-size: 18px;
        font-weight: 700;
        color: #007cf8;
        padding: 4px 12px;
    }

    .zoom-controls-container {
        display: flex;
        align-items: center;
        justify-content: center;
        gap: 20px;
        flex-wrap: wrap;
    }

    .zoom-button {
        width: 50px;
        height: 50px;
        border-radius: 50%;
        border: none;
        background: linear-gradient(135deg, #007cf8 0%, #0056b3 100%);
        color: white;
        font-size: 24px;
        font-weight: bold;
        cursor: pointer;
        transition: all 0.3s ease;
        box-shadow: 0 4px 12px rgba(0, 124, 248, 0.3);
        display: flex;
        align-items: center;
        justify-content: center;
        user-select: none;
        position: relative;
        overflow: hidden;
    }

    .zoom-button::before {
        content: '';
        position: absolute;
        top: 50%;
        left: 50%;
        width: 0;
        height: 0;
        background: rgba(255, 255, 255, 0.3);
        border-radius: 50%;
        transition: all 0.3s ease;
        transform: translate(-50%, -50%);
    }

    .zoom-button:hover::before {
        width: 100%;
        height: 100%;
    }

    .zoom-button:hover {
        transform: scale(1.1);
        box-shadow: 0 6px 20px rgba(0, 124, 248, 0.4);
    }

    .zoom-button:active {
        transform: scale(0.95);
    }

    .zoom-button:disabled {
        opacity: 0.5;
        cursor: not-allowed;
        transform: none;
    }

    .zoom-button:disabled:hover {
        transform: none;
        box-shadow: 0 4px 12px rgba(0, 124, 248, 0.3);
    }

    .zoom-slider-container {
        position: relative;
        flex: 1;
        max-width: 300px;
        margin: 0 20px;
    }

    .zoom-slider {
        width: 100%;
        height: 8px;
        border-radius: 10px;
        background: transparent;
        outline: none;
        -webkit-appearance: none;
        appearance: none;
        cursor: pointer;
        position: relative;
        z-index: 2;
    }

    .zoom-slider-track {
        position: absolute;
        top: 50%;
        left: 0;
        right: 0;
        height: 8px;
        background: linear-gradient(90deg, #e0e0e0 0%, #f0f0f0 50%, #e0e0e0 100%);
        border-radius: 10px;
        transform: translateY(-50%);
        box-shadow: inset 0 2px 4px rgba(0, 0, 0, 0.1);
        border: 1px solid #d0d0d0;
    }

    .zoom-slider::-webkit-slider-thumb {
        -webkit-appearance: none;
        appearance: none;
        width: 28px;
        height: 28px;
        border: 3px solid #ffffff;
        border-radius: 50%;
        cursor: pointer;
        background: linear-gradient(135deg, #007cf8 0%, #0056b3 100%);
        box-shadow: 0 4px 12px rgba(0, 124, 248, 0.4), 0 2px 6px rgba(0, 0, 0, 0.2);
        transition: all 0.2s ease;
        position: relative;
        z-index: 3;
    }

    .zoom-slider::-webkit-slider-thumb:hover {
        transform: scale(1.15);
        box-shadow: 0 6px 16px rgba(0, 124, 248, 0.5), 0 3px 8px rgba(0, 0, 0, 0.3);
    }

    .zoom-slider::-webkit-slider-thumb:active {
        transform: scale(1.05);
    }

    .zoom-slider::-moz-range-thumb {
        width: 28px;
        height: 28px;
        border: 3px solid #ffffff;
        border-radius: 50%;
        cursor: pointer;
        background: linear-gradient(135deg, #007cf8 0%, #0056b3 100%);
        box-shadow: 0 4px 12px rgba(0, 124, 248, 0.4), 0 2px 6px rgba(0, 0, 0, 0.2);
        transition: all 0.2s ease;
    }

    .zoom-slider::-moz-range-thumb:hover {
        transform: scale(1.15);
        box-shadow: 0 6px 16px rgba(0, 124, 248, 0.5), 0 3px 8px rgba(0, 0, 0, 0.3);
    }

    .zoom-slider::-moz-range-track {
        height: 8px;
        border-radius: 10px;
        background: transparent;
        border: none;
    }

    /* Responsive para zoom */
    @media (max-width: 768px) {
        .zoom-control-panel {
            padding: 15px;
            margin: 5px 0;
        }

        .zoom-controls-container {
            gap: 15px;
        }

        .zoom-button {
            width: 45px;
            height: 45px;
            font-size: 22px;
        }

        .zoom-slider-container {
            margin: 0 15px;
            max-width: 250px;
        }

        .zoom-label {
            font-size: 14px;
        }

        .zoom-percentage {
            font-size: 16px;
        }
    }

    @media (max-width: 480px) {
        .zoom-control-panel {
            padding: 12px;
        }

        .zoom-controls-container {
            gap: 8px;
            flex-direction: row;
            justify-content: center;
            align-items: center;
        }

        .zoom-button {
            width: 40px;
            height: 40px;
            font-size: 18px;
            flex-shrink: 0;
        }

        .zoom-slider-container {
            margin: 0 10px;
            max-width: 150px;
            flex: 1;
        }

        .zoom-label {
            font-size: 13px;
        }

        .zoom-percentage {
            font-size: 15px;
        }
    }

    @media (max-width: 360px) {
        .zoom-control-panel {
            padding: 10px;
        }

        .zoom-controls-container {
            gap: 6px;
        }

        .zoom-button {
            width: 35px;
            height: 35px;
            font-size: 16px;
        }

        .zoom-slider-container {
            margin: 0 8px;
            max-width: 120px;
        }

        .zoom-label {
            font-size: 12px;
        }

        .zoom-percentage {
            font-size: 14px;
        }
    }

    /* Contenedor del slider mejorado */
    .zoom-container {
        background: rgba(255, 255, 255, 0.95);
        border-radius: 15px;
        padding: 20px;
        box-shadow: 0 8px 25px rgba(0, 0, 0, 0.15);
        backdrop-filter: blur(10px);
        border: 1px solid rgba(255, 255, 255, 0.3);
        margin: 10px 0;
    }

    .zoom-label {
        font-size: 16px;
        font-weight: 700;
        color: #333;
        margin-bottom: 15px;
        text-align: center;
        text-shadow: 0 1px 2px rgba(0, 0, 0, 0.1);
    }

    .zoom-controls {
        display: flex;
        align-items: center;
        gap: 20px;
        justify-content: center;
    }

    .zoom-btn {
        border-radius: 50%;
        border: none;
        background: linear-gradient(135deg, #007cf8 0%, #0056b3 100%);
        color: white;
        font-weight: bold;
        cursor: pointer;
        transition: all 0.3s ease;
        box-shadow: 0 3px 8px rgba(0, 124, 248, 0.3);
        display: flex;
        align-items: center;
        justify-content: center;
        user-select: none;
    }

    .zoom-btn:hover {
        transform: scale(1.1);
        box-shadow: 0 6px 16px rgba(0, 124, 248, 0.4);
    }

    .zoom-btn:active {
        transform: scale(0.95);
    }

    .zoom-btn:disabled {
        opacity: 0.5;
        cursor: not-allowed;
        transform: none;
    }

    .zoom-value {
        font-size: 18px;
        font-weight: 700;
        color: #007cf8;
        min-width: 50px;
        text-align: center;
        text-shadow: 0 1px 2px rgba(0, 0, 0, 0.1);
    }

    .slidecontainer {
        position: relative;
        margin: 0 10px;
    }

    /* Responsive para zoom */
    @media (max-width: 768px) {
        .zoom-container {
            padding: 15px;
            margin: 5px 0;
        }

        .zoom-controls {
            gap: 15px;
        }

        .zoom-btn {
            width: 40px;
            height: 40px;
            font-size: 18px;
        }

        .zoom-value {
            font-size: 16px;
            min-width: 45px;
        }

        .slidecontainer {
            margin: 0 15px;
        }
    }

    @media (max-width: 480px) {
        .zoom-container {
            padding: 12px;
        }

        .zoom-controls {
            gap: 10px;
        }

        .zoom-btn {
            width: 35px;
            height: 35px;
            font-size: 16px;
        }

        .zoom-value {
            font-size: 14px;
            min-width: 40px;
        }

        .slidecontainer {
            margin: 0 10px;
        }
    }





    body {
        -webkit-text-size-adjust: none;
        /*touch-action: manipulation;*/
        touch-action: pan-x pan-y;
        overflow-x: hidden;
    }


    .boxok {
        box-shadow: rgba(0, 0, 0, 0.25) 0px 54px 55px, rgba(0, 0, 0, 0.12) 0px -12px 30px, rgba(0, 0, 0, 0.12) 0px 4px 6px, rgba(0, 0, 0, 0.17) 0px 12px 13px, rgba(0, 0, 0, 0.09) 0px -3px 5px;
        border-radius: 15px 0px 15px 0px;
        box-shadow: 2px 2px 5px #999999;
    }


    a {
        color: #28f;
        text-decoration: none;
    }

    a:hover,
    a:focus {
        color: #0062d5;
    }

    a:active {
        color: #003f88;
    }

    main {
        margin: 0 auto;
        max-width: auto;
        padding: 1em;
    }

    .article-list__page {
        border-top: 1px solid #ddd;
        clear: both;
        counter-increment: page;
        padding-bottom: 3em;
        position: relative;
    }

    .article-list__page:before {
        background-color: #ddd;
        display: inline-block;
        content: counter(page);
        color: #888;
        padding: 0.25em 0.5em;
        position: absolute;
        left: calc(50% - .75em);
        top: -0.75em;
        vertical-align: middle;
        z-index: 1;
    }

    .article-list__item {
        background-color: #eee;
        /*float: left;*/
        height: auto;
        /*max-width: 50%;*/
        /*opacity: 0.75;
  transform: scale(0.8);*/
        transition: opacity 0.2s, transform 0.2s;

    }

    .article-list__item:hover {
        opacity: 1;
        transform: scale(1);
    }

    .article-list__item__image {
        display: block;
        height: auto;
        margin: 0;
        opacity: 1;
        transition: opacity 0.2s;
        width: 100%;
    }

    .article-list__item__image--loading {
        opacity: 0;
    }

    .article-list__pagination {
        background-color: #222;
        display: block;
        bottom: 0;
        left: 0;
        list-style-type: none;
        right: 0;
        text-align: center;
        transform: translateY(0);
        transition: transform 0.2s;
        height: 120px;
        -webkit-transform: translateZ(1px);
        z-index: 999;
        /*opacity: 0.5;*/
    }

    .article-list__pagination--inactive {
        transform: translateY(100%);
    }

    .article-list__pagination__item {
        display: inline-block;
        margin: 0 1em;
    }

    .article-list__pagination__item a {
        color: #888;
        text-decoration: none;
    }

    .article-list__pagination__item a:hover,
    .article-list__pagination__item a:focus {
        color: #aeaeae;
    }

    .article-list__pagination__item a:active {
        color: #d5d5d5;
    }

    /* Paginador Mejorado */
    .article-list__pagination {
        background: white !important;
        padding: 20px 0 !important;
        margin-top: 20px !important;
    }

    /* Custom Pagination Styles */
    .custom-pagination-wrapper {
        background: transparent;
        padding: 20px;
        margin-top: 15px;
    }

    .custom-pagination {
        display: flex;
        justify-content: center;
        align-items: center;
        gap: 6px;
        margin-top: 15px;
        flex-wrap: nowrap;
        overflow-x: auto;
        -webkit-overflow-scrolling: touch;
        scrollbar-width: none;
        -ms-overflow-style: none;
    }

    .custom-pagination::-webkit-scrollbar {
        display: none;
    }

    .pagination-btn {
        display: inline-flex;
        align-items: center;
        justify-content: center;
        min-width: 36px;
        height: 36px;
        padding: 0 8px;
        background: white;
        border: 2px solid #e9ecef;
        border-radius: 8px;
        color: #667eea;
        text-decoration: none;
        font-weight: 600;
        font-size: 13px;
        transition: all 0.3s ease;
        cursor: pointer;
        flex-shrink: 0;
        white-space: nowrap;
    }

    .pagination-btn:hover {
        background: #667eea;
        border-color: #667eea;
        color: white;
        transform: translateY(-2px);
        box-shadow: 0 6px 16px rgba(102, 126, 234, 0.3);
        text-decoration: none;
    }

    .pagination-btn.active {
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        border-color: #667eea;
        color: white;
        box-shadow: 0 4px 12px rgba(102, 126, 234, 0.4);
    }

    .pagination-btn.disabled {
        background: #f8f9fa;
        border-color: #e9ecef;
        color: #adb5bd;
        cursor: not-allowed;
        transform: none;
    }

    .pagination-btn.disabled:hover {
        background: #f8f9fa;
        border-color: #e9ecef;
        color: #adb5bd;
        transform: none;
        box-shadow: none;
    }

    .pagination-dots {
        display: inline-flex;
        align-items: center;
        justify-content: center;
        min-width: 40px;
        height: 40px;
        color: #6c757d;
        font-weight: 600;
        font-size: 16px;
    }

    .pagination-info {
        text-align: center;
        color: #6c757d;
        font-size: 14px;
        font-weight: 500;
        margin-bottom: 10px;
    }

    /* Responsive Pagination */
    @media (max-width: 768px) {
        .custom-pagination {
            gap: 4px;
            padding: 0 10px;
        }

        .pagination-btn {
            min-width: 32px;
            height: 32px;
            font-size: 12px;
            padding: 0 6px;
        }

        .pagination-info {
            font-size: 13px;
        }
    }

    @media (max-width: 480px) {
        .custom-pagination {
            gap: 3px;
            padding: 0 5px;
        }

        .pagination-btn {
            min-width: 30px;
            height: 30px;
            font-size: 11px;
            padding: 0 4px;
        }

        .pagination-dots {
            min-width: 20px;
            height: 30px;
            font-size: 12px;
        }

        .pagination-info {
            font-size: 12px;
            margin-bottom: 8px;
        }
    }

    @media (max-width: 360px) {
        .custom-pagination {
            gap: 2px;
            padding: 0 2px;
        }

        .pagination-btn {
            min-width: 28px;
            height: 28px;
            font-size: 10px;
            padding: 0 3px;
        }

        .pagination-dots {
            min-width: 18px;
            height: 28px;
            font-size: 11px;
        }
    }

    .soft-pagination-items {
        color: #ffffff;
        cursor: pointer;
        list-style: none;
        padding: 0;
        margin: 0;
        display: flex;
        justify-content: center;
        align-items: center;
        flex-wrap: wrap;
        gap: 8px;
        padding: 20px 10px;
    }

    .soft-pagination-items li {
        display: inline-flex;
        align-items: center;
        justify-content: center;
        min-width: 45px;
        height: 45px;
        padding: 0 15px;
        font-weight: 700;
        font-size: 16px;
        border-radius: 12px;
        transition: all 0.3s ease;
        background: rgba(255, 255, 255, 0.25) !important;
        border: 2px solid rgba(255, 255, 255, 0.4) !important;
        position: relative;
        overflow: hidden;
        color: #ffffff !important;
    }

    .soft-pagination-items li::before {
        content: '';
        position: absolute;
        top: 0;
        left: -100%;
        width: 100%;
        height: 100%;
        background: linear-gradient(90deg, transparent, rgba(255, 255, 255, 0.2), transparent);
        transition: left 0.5s ease;
    }

    .soft-pagination-items li:hover::before {
        left: 100%;
    }

    .soft-pagination-items li.active {
        background: linear-gradient(135deg, #ff6b6b 0%, #ee5a24 100%) !important;
        color: #ffffff !important;
        border: 2px solid rgba(255, 255, 255, 0.3);
        box-shadow: 0 4px 15px rgba(255, 107, 107, 0.4);
        transform: scale(1.05);
    }

    .soft-pagination-items li:hover {
        background: linear-gradient(135deg, rgba(255, 255, 255, 0.2) 0%, rgba(255, 255, 255, 0.1) 100%);
        color: #ffffff !important;
        border: 2px solid rgba(255, 255, 255, 0.3);
        transform: translateY(-2px);
        box-shadow: 0 6px 20px rgba(0, 0, 0, 0.2);
    }

    .soft-pagination-items li:active {
        transform: scale(0.95);
    }

    .soft-pagination-items a {
        color: inherit !important;
        text-decoration: none !important;
        display: flex;
        align-items: center;
        justify-content: center;
        width: 100%;
        height: 100%;
    }

    .soft-pagination-items a:hover {
        color: inherit !important;
        text-decoration: none !important;
    }

    /* Responsive para paginador */
    @media (max-width: 768px) {
        .soft-pagination-items li {
            min-width: 40px;
            height: 40px;
            font-size: 14px;
            padding: 0 12px;
        }

        .soft-pagination-items {
            gap: 6px;
            padding: 15px 5px;
        }
    }

    @media (max-width: 480px) {
        .soft-pagination-items li {
            min-width: 35px;
            height: 35px;
            font-size: 13px;
            padding: 0 10px;
        }

        .soft-pagination-items {
            gap: 4px;
            padding: 12px 3px;
        }
    }

    /*Letas*/
    /*Letras */
    .center {
        display: grid;
        width: auto;
        justify-items: center;
    }

    .h-div {
        height: 300px;
    }

    .w-300 {
        min-width: 400px;
    }

    .region {
        perspective: 2000;
        transform-style: preserve-3d;
    }

    .outer {
        width: 100%;
        /*height: 400px;*/
        position: absolute;
        transform-style: preserve-3d;
        animation: rotate 5s infinite alternate ease-in-out -7.5s forwards;
        transform: rotateY(15deg) rotateX(10deg) translateZ(0) !important;
        will-change: transform;
        z-index: 20;
    }

    .layer {
        text-align: center;
        width: 100%;
        position: absolute;
        color: #fff;


    }

    .layer div {
        text-shadow: 4px 0 10px rgba(0, 0, 0, 0.13);
    }

    .layer:nth-child(1) {

        z-index: 1;
    }

    .layer:nth-child(2) {
        transform: translateZ(-1.5px);
        z-index: 2;
    }

    .layer:nth-child(3) {
        transform: translateZ(-3px);
        z-index: 3;
    }

    .layer:nth-child(4) {
        transform: translateZ(-4.5px);
        z-index: 4;
    }

    .layer:nth-child(5) {
        transform: translateZ(-6px);
        z-index: 5;
    }

    .layer:nth-child(6) {
        transform: translateZ(-7.5px);
        z-index: 6;
    }

    .layer:nth-child(7) {
        transform: translateZ(-9px);
        z-index: 7;
    }

    .layer:nth-child(8) {
        transform: translateZ(-10.5px);
        z-index: 8;
    }

    .layer:nth-child(9) {
        transform: translateZ(-12px);
        z-index: 9;
    }

    .layer:nth-child(10) {
        transform: translateZ(-13.5px);
        z-index: 10;
    }

    .color1 {
        /* -webkit-text-stroke: 15px #f0e68c !important;*/
    }

    .layer:nth-child(11) {
        transform: translateZ(-15px);
        z-index: 11;
    }

    .layer:nth-child(12) {
        transform: translateZ(-16.5px);
        z-index: 12;
    }

    .layer:nth-child(13) {
        transform: translateZ(-18px);
        z-index: 13;
    }

    .layer:nth-child(14) {
        transform: translateZ(-19.5px);
        z-index: 14;
    }

    .layer:nth-child(15) {
        transform: translateZ(-21px);
        z-index: 15;
    }

    .layer:nth-child(16) {
        transform: translateZ(-22.5px);
        z-index: 16;
    }

    .layer:nth-child(17) {
        transform: translateZ(-24px);
        z-index: 17;
    }

    .layer:nth-child(18) {
        transform: translateZ(-25.5px);
        z-index: 18;
    }

    .layer:nth-child(19) {
        transform: translateZ(-27px);
        z-index: 19;
    }

    .layer:nth-child(20) {
        transform: translateZ(-28.5px);
        z-index: 20;
    }


    .caja-texto {

        width: auto;
        height: auto;
        /* padding-top: 50px;*/

    }
</style>
<?php
echo '<style>';

foreach ($html as $htmlfont) {
    # code...
    echo $htmlfont['csscode'];
}

echo '</style>';
?>

<body class="loginbg" style="margin: 10px">
    <?php
    
    ?>
    <div class="container-fluid">
        <div class="row">
            <div class="col-xs-12 col-sm-12" style="text-align: center;">
                <img src="/img/logo-avi.png" alt="" style="width: 100px; margin-bottom:10px;">
            </div>
        </div>
        <div class="row">

            <div class="col-xs-12 col-sm-12" style="text-align: center;">
                <div style="font-weight: 600; font-size:18px;">Font Wizard Pro Preview</div>
                <img src="" alt="">
            </div>
        </div>

        <div class="row" id="square">
            <?php
            foreach ($html as $htmlfont) {
                # code...
                echo $htmlfont['htmlcode'];
            }
            ?>
        </div>
        <div class="row">

            <div class="col-xs-12" style="height: 100px;">
                <div class="row article-list__pagination" id="article-list-pagination">
                    <div class="col-xs-12" style="z-index:10">
                        <div class="row" style="margin-bottom: 30px;margin-top:20px">
                            <div class="col-xs-12">
                                <div class="zoom-control-panel">
                                    <div class="zoom-info">
                                        <span class="zoom-label">🔍 Font Size: </span>
                                        <span class="zoom-percentage" id="zoomPercentage">100%</span>
                                    </div>

                                    <div class="zoom-controls-container">
                                        <button class="zoom-button zoom-decrease" id="zoomDecrease" type="button">
                                            <span>−</span>
                                        </button>

                                        <div class="zoom-slider-container">
                                            <input type="range" min="-20" max="20" value="0"
                                                step="1" class="zoom-slider" id="zoomSlider">
                                            <div class="zoom-slider-track"></div>
                                        </div>

                                        <button class="zoom-button zoom-increase" id="zoomIncrease" type="button">
                                            <span>+</span>
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-xs-12 col-sm-12" style="text-align: center;">
                                <div class="custom-pagination-wrapper">
                                    <div class="pagination-info">
                                        Showing page {{ $pageactual }} of {{ $pagetotal }} pages
                                    </div>

                                    <div class="custom-pagination">
                                        {{-- Previous Button --}}
                                        @if ($pageactual <= 1)
                                            <span class="pagination-btn disabled">
                                                <i class="fas fa-chevron-left"></i>
                                            </span>
                                        @else
                                            <a href="{{ url('/previewall/' . $layer . '/' . $id . '/' . $color . '/' . ($pageactual - 1) . '/' . $token) }}"
                                                class="pagination-btn">
                                                <i class="fas fa-chevron-left"></i>
                                            </a>
                                        @endif

                                        {{-- Responsive Page Numbers --}}
                                        @php
                                            // Lógica responsive para móviles
                                            if ($pagetotal <= 7) {
                                                // Si hay 7 páginas o menos, mostrar todas
                                                $start = 1;
                                                $end = $pagetotal;
                                                $showFirstLast = false;
                                                $showDots = false;
                                            } else {
                                                // Lógica para páginas con puntos suspensivos
                                                $showFirstLast = true;
                                                $showDots = true;

                                                if ($pageactual <= 4) {
                                                    $start = 1;
                                                    $end = 5;
                                                } elseif ($pageactual >= $pagetotal - 3) {
                                                    $start = $pagetotal - 4;
                                                    $end = $pagetotal;
                                                } else {
                                                    $start = $pageactual - 2;
                                                    $end = $pageactual + 2;
                                                }
                                            }
                                        @endphp

                                        {{-- Primera página --}}
                                        @if ($showFirstLast && $start > 1)
                                            <a href="{{ url('/previewall/' . $layer . '/' . $id . '/' . $color . '/1/' . $token) }}"
                                                class="pagination-btn">1</a>
                                            @if ($start > 2)
                                                <span class="pagination-dots">...</span>
                                            @endif
                                        @endif

                                        {{-- Páginas del medio --}}
                                        @for ($i = $start; $i <= $end; $i++)
                                            @if ($i == $pageactual)
                                                <span class="pagination-btn active">{{ $i }}</span>
                                            @else
                                                <a href="{{ url('/previewall/' . $layer . '/' . $id . '/' . $color . '/' . $i . '/' . $token) }}"
                                                    class="pagination-btn">{{ $i }}</a>
                                            @endif
                                        @endfor

                                        {{-- Última página --}}
                                        @if ($showFirstLast && $end < $pagetotal)
                                            @if ($end < $pagetotal - 1)
                                                <span class="pagination-dots">...</span>
                                            @endif
                                            <a href="{{ url('/previewall/' . $layer . '/' . $id . '/' . $color . '/' . $pagetotal . '/' . $token) }}"
                                                class="pagination-btn">{{ $pagetotal }}</a>
                                        @endif

                                        {{-- Next Button --}}
                                        @if ($pageactual >= $pagetotal)
                                            <span class="pagination-btn disabled">
                                                <i class="fas fa-chevron-right"></i>
                                            </span>
                                        @else
                                            <a href="{{ url('/previewall/' . $layer . '/' . $id . '/' . $color . '/' . ($pageactual + 1) . '/' . $token) }}"
                                                class="pagination-btn">
                                                <i class="fas fa-chevron-right"></i>
                                            </a>
                                        @endif
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

        </div>



    </div>
    <script src="{{ asset('assets/global/plugins/admin/js/vendor/jquery-1.11.2.min.js') }}"></script>
    <script>
        jQuery(document).ready(function($) {
            // Set initial zoom level
            const fonts1 = <?php echo json_encode($fonts); ?>;
            const design_name = <?php echo json_encode($design_name); ?>;
            $("#dinamic").html("");
            $("#dinamic1").html("");
            default_css(fonts1, design_name);
            console.log(fonts1);

            // Nuevo Sistema de Zoom - JavaScript
            let currentZoomValue = 0;

            // Función para actualizar la visualización del zoom
            function updateZoomDisplay(value) {
                currentZoomValue = parseInt(value);
                const percentage = 100 + (currentZoomValue * 5);
                $('#zoomPercentage').text(percentage + '%');

                // Actualizar estado de los botones
                $('#zoomDecrease').prop('disabled', currentZoomValue <= -20);
                $('#zoomIncrease').prop('disabled', currentZoomValue >= 20);
            }

            // Función para aplicar el zoom
            function applyZoom(value) {
                console.log('Aplicando zoom:', value);
                if (value !== 0) {
                    zoom_font(value, fonts1, design_name);
                } else {
                    zoom_font(0, fonts1, design_name);
                }
            }

            // Función para cambiar el zoom
            function changeZoom(newValue) {
                if (newValue >= -20 && newValue <= 20) {
                    $('#zoomSlider').val(newValue);
                    updateZoomDisplay(newValue);
                    applyZoom(newValue);
                }
            }

            // Eventos del slider
            $('#zoomSlider').on('input change', function() {
                const value = parseInt($(this).val());
                updateZoomDisplay(value);
                applyZoom(value);
            });

            // Evento del botón disminuir
            $('#zoomDecrease').on('click', function() {
                if (!$(this).prop('disabled')) {
                    changeZoom(currentZoomValue - 1);
                }
            });

            // Evento del botón aumentar
            $('#zoomIncrease').on('click', function() {
                if (!$(this).prop('disabled')) {
                    changeZoom(currentZoomValue + 1);
                }
            });

            // Inicializar zoom
            updateZoomDisplay(0);
            var zoom_level = 100;
            // Zoom function
            function zoom_font(step, fonts, design_name) {
                console.log(fonts)
                $("#dinamic1").html("");
                $("#dinamic").html("");
                for (let index = 0; index < fonts.length; index++) {
                    var sizev = Number(Number(fonts[index]["fontsize1"]) - 4) + Number(step);
                    if (design_name.length <= 3) {
                        var sizem = Number(Number(fonts[index]["fontsize1"]) + 10) + Number(step);
                    } else if (design_name.length > 3 && design_name.length <= 6) {
                        var sizem = Number(Number(fonts[index]["fontsize1"]) + 7) + Number(step);
                    } else {
                        var sizem = Number(Number(fonts[index]["fontsize1"]) + 2) + Number(step);
                    }

                    var stylex = ".texto" + fonts[index]["id"] + "{font-size:" + sizev + "vw !important;}";
                    var stylemovil = "@media only screen and (min-width: 360px) and (max-width: 768px) { .texto" +
                        fonts[index]["id"] + " {font-size:" + sizem + "vw !important; } }";
                    $("#dinamic").append(stylex);
                    $("#dinamic1").append(stylemovil);
                }
            }

            function default_css(fonts, design_name) {
                $("#dinamic1").html("");
                var sizem = 0;
                for (let index = 0; index < fonts.length; index++) {

                    if (design_name.length <= 3) {
                        sizem = Number(Number(fonts[index]["fontsize1"]) + 10);
                    } else if (design_name.length > 3 && design_name.length <= 6) {
                        sizem = Number(Number(fonts[index]["fontsize1"]) + 7);
                    } else {
                        sizem = Number(Number(fonts[index]["fontsize1"]) + 2);
                    }

                    // var stylex = ".layer" + fonts[index]["id"] + ":after {font-size:" + sizev + "vw !important;}";
                    var stylemovil = "@media only screen and (min-width: 360px) and (max-width: 768px) { .texto" +
                        fonts[index]["id"] + " {font-size:" + sizem + "vw !important; } }";

                    $("#dinamic1").append(stylemovil);
                }

            }
        });
    </script>

</body>

</html>
