<?php
use App\Libraries\Common;

?>
<!DOCTYPE html>
<!--[if IE 8]> <html lang="en" class="ie8 no-js"> <![endif]-->
<!--[if IE 9]> <html lang="en" class="ie9 no-js"> <![endif]-->
<!--[if !IE]><!-->
<html lang="{{ app()->getLocale() }}">
<!--<![endif]-->
<!-- BEGIN HEAD -->

<head>
    <meta charset="utf-8" />
    <!-- CSRF Token -->
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <title>{{ config('app.name', 'Fonts Wizard Preview') }}</title>
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta content="width=device-width, initial-scale=1" name="viewport" />
    <meta content="{{ config('app.name', 'Fonts Wizard Preview') }}" name="description" />
    <meta content="" name="author" />


    <link href="{{ asset('assets/global/plugins/bootstrap/css/bootstrap.min.css') }}" rel="stylesheet"
        type="text/css" />
    <link href="{{ asset('assets/global/plugins/bootstrap-switch/css/bootstrap-switch.min.css') }}" rel="stylesheet"
        type="text/css" />
    <link href="{{ asset('assets/layouts/layout2/css/custom.min.css') }}" rel="stylesheet" type="text/css" />

    <!-- Custom Fonts -->
    <link rel="stylesheet"
        href="{{ asset('fonts/custom/stylesheet.css') }}?v={{ file_exists(public_path('fonts/custom/stylesheet.css')) ? filemtime(public_path('fonts/custom/stylesheet.css')) : time() }}">

    <!-- BEGIN GLOBAL MANDATORY STYLES -->
    <!--<link href="http://fonts.googleapis.com/css?family=Open+Sans:400,300,600,700&subset=all" rel="stylesheet" type="text/css" />-->

    <!-- END HEAD -->

    <style>
        .boxok {
            box-shadow: rgba(0, 0, 0, 0.25) 0px 54px 55px, rgba(0, 0, 0, 0.12) 0px -12px 30px, rgba(0, 0, 0, 0.12) 0px 4px 6px, rgba(0, 0, 0, 0.17) 0px 12px 13px, rgba(0, 0, 0, 0.09) 0px -3px 5px;
            border-radius: 15px 0px 15px 0px;
            box-shadow: 2px 2px 5px #999999;
        }

        @media only screen and (min-width: 360px) and (max-width: 768px) {

            .stage,
            .stage1 {
                height: 200px !important;
            }
        }

        @media only screen and (min-width: 800px) and (max-width: 1090px) {

            .stage,
            .stage1 {
                height: 300px !important;
            }
        }
    </style>

<body class="loginbg" style="margin: 10px">


    <div class="container-fluid">
        <div class="row">
            <div class="col-xs-12 col-sm-12" style="text-align: center;">
                <img src="/img/logo-avi.png" alt="" style="width: 100px; margin-bottom:10px;">
            </div>
        </div>
        <div class="row">
            <div class="col-xs-12 col-sm-12" style="text-align: center;">
                <div style="font-weight: 600; font-size:18px;">Font Wizard Pro Preview</div>
                <img src="" alt="">
            </div>
        </div>
        <?php
        foreach ($imagenes as $imagen) {
            echo "<div class='row'><div class='col-xs-12 col-sm-12'>";
            echo "<img src='" . $imagen['url'] . "'></div></div>";
        }
        
        ?>


    </div>
</body>

</html>
