<?php
use App\Libraries\Common;
?>
<!DOCTYPE html>
<!--[if IE 8]> <html lang="en" class="ie8 no-js"> <![endif]-->
<!--[if IE 9]> <html lang="en" class="ie9 no-js"> <![endif]-->
<!--[if !IE]><!-->
<html lang="{{ app()->getLocale() }}">
<!--<![endif]-->
<!-- BEGIN HEAD -->

<head>
    <meta charset="utf-8" />
    <!-- CSRF Token -->
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <title>{{ config('app.name', 'Fonts Wizard Preview') }}</title>
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta content="width=device-width,user-scalable=yes,maximum-scale=10" name="viewport" />
    <meta content="{{ config('app.name', 'Fonts Wizard Preview') }}" name="description" />
    <meta content="" name="author" />


    <link href="{{ asset('assets/global/plugins/bootstrap/css/bootstrap.min.css') }}" rel="stylesheet"
        type="text/css" />
    <link href="{{ asset('assets/global/plugins/bootstrap-switch/css/bootstrap-switch.min.css') }}" rel="stylesheet"
        type="text/css" />
    <link href="{{ asset('assets/layouts/layout2/css/custom.min.css') }}" rel="stylesheet" type="text/css" />

    <!-- Custom Fonts -->
    <link rel="stylesheet"
        href="{{ asset('fonts/custom/stylesheet.css') }}?v={{ file_exists(public_path('fonts/custom/stylesheet.css')) ? filemtime(public_path('fonts/custom/stylesheet.css')) : time() }}">

    <!-- BEGIN GLOBAL MANDATORY STYLES -->
    <!--<link href="http://fonts.googleapis.com/css?family=Open+Sans:400,300,600,700&subset=all" rel="stylesheet" type="text/css" />-->

    <!-- END HEAD -->

    <style>
        @media only screen and (min-width: 360px) and (max-width: 768px) {
            .layer:after {
                font-size: 23vw !important;
            }

            .layer1:after {
                font-size: 23vw !important;
            }

            .layera:after {
                font-size: 23vw !important;
            }

        }

        .stage {
            height: 300px;
            width: auto;
            margin: auto;
            /* position: absolute;*/
            top: 0;
            right: 0;
            bottom: 0;
            left: 0;
            perspective: 9999px;
            transform-style: preserve-3d;
        }

        .stage1 {
            height: 300px;
            width: auto;
            margin: auto;
            top: 0;
            right: 0;
            bottom: 0;
            left: 0;
            perspective: 9999px;
            transform-style: preserve-3d;
        }

        .boxok {
            box-shadow: rgba(0, 0, 0, 0.35) 0px 5px 15px;

        }

        .modal {
            display: none;
            /* Hidden by default */
            position: fixed;
            /* Stay in place */
            z-index: 100;
            /* Sit on top */
            left: 0;
            top: 10%;
            width: 100%;
            /* Full width */
            height: 100%;
            /* Full height */
            overflow: auto;
            /* Enable scroll if needed */
            background-color: rgb(0, 0, 0);
            /* Fallback color */
            background-color: rgba(0, 0, 0, 0.4);
            /* Black w/ opacity */
        }

        .box_modal {
            box-shadow: rgba(0, 0, 0, 0.35) 0px 5px 15px;
            border-radius: 5px;
        }

        /* Modal Content/Box */
        .modal-content {
            background-color: #fefefe;
            margin: 15% auto;
            /* 15% from the top and centered */
            padding: 10px 10px 40px 10px;
            border: 1px solid #888;
            width: 80%;
            /* Could be more or less, depending on screen size */
        }

        /* The Close Button */
        .close {
            color: #aaa;
            float: right;
            font-size: 28px;
            font-weight: bold;
        }

        .body_preview {
            background: radial-gradient(circle, #0077ea, #1f4f96, #1b2949, #000);
        }

        @media only screen and (min-width: 360px) and (max-width: 768px) {

            .stage,
            .stage1 {
                height: 200px !important;
            }
        }

        @media only screen and (min-width: 800px) and (max-width: 1090px) {

            .stage,
            .stage1 {
                height: 300px !important;
            }
        }
    </style>

<body class="loginbg" style="margin: 10px">

    <?php
    
    if ($layer == 'layer1') {
        $style_color = $order->color_style_layer1;
    } else {
        $style_color = $order->color_style_layer2;
    }
    
    echo '<style>';
    
    foreach ($fonts as $font) {
        if ($layer == 'layer1') {
            $style_color_ok1 = str_replace('layer1', 'auxiliar1capa' . $font['id'], $style_color);
            echo $style_color_ok1;
            $style_font = '';
            $style_font = '.auxiliar1capa' . $font['id'] . ':after {';
            $style_font .= "content:'" . $order->design_name . "';";
            $style_font .= $font['style'];
            $style_font .= '}';
    
            $style_font .= '.auxiliar1capa' . $font['id'] . ':nth-child(1):after {transform: translateZ(0px);}';
            $style_font .= '.auxiliar1capa' . $font['id'] . ':nth-child(2):after {transform: translateZ(-1.5px);}';
            $style_font .= '.auxiliar1capa' . $font['id'] . ':nth-child(3):after {transform: translateZ(-3px);}';
            $style_font .= '.auxiliar1capa' . $font['id'] . ':nth-child(4):after {transform: translateZ(-4.5px);}';
            $style_font .= '.auxiliar1capa' . $font['id'] . ':nth-child(5):after {transform: translateZ(-6px);}';
            $style_font .= '.auxiliar1capa' . $font['id'] . ':nth-child(6):after {transform: translateZ(-7.5px);}';
            $style_font .= '.auxiliar1capa' . $font['id'] . ':nth-child(7):after {transform: translateZ(-9px);}';
            $style_font .= '.auxiliar1capa' . $font['id'] . ':nth-child(8):after {transform: translateZ(-10.5px);}';
            $style_font .= '.auxiliar1capa' . $font['id'] . ':nth-child(9):after {transform: translateZ(-12px);}';
            $style_font .= '.auxiliar1capa' . $font['id'] . ':nth-child(10):after {transform: translateZ(-13.5px);}';
            $style_font .= '.auxiliar1capa' . $font['id'] . ':nth-child(11):after {transform: translateZ(-15px);}';
            $style_font .= '.auxiliar1capa' . $font['id'] . ':nth-child(12):after {transform: translateZ(-16.5px);}';
            $style_font .= '.auxiliar1capa' . $font['id'] . ':nth-child(13):after {transform: translateZ(-18px);}';
            $style_font .= '.auxiliar1capa' . $font['id'] . ':nth-child(14):after {transform: translateZ(-19.5px);}';
            $style_font .= '.auxiliar1capa' . $font['id'] . ':nth-child(15):after {transform: translateZ(-21px);}';
            $style_font .= '.auxiliar1capa' . $font['id'] . ':nth-child(16):after {transform: translateZ(-22.5px);}';
            $style_font .= '.auxiliar1capa' . $font['id'] . ':nth-child(17):after {transform: translateZ(-24px);}';
            $style_font .= '.auxiliar1capa' . $font['id'] . ':nth-child(18):after {transform: translateZ(-25.5px);}';
            $style_font .= '.auxiliar1capa' . $font['id'] . ':nth-child(19):after {transform: translateZ(-27px);}';
            $style_font .= '.auxiliar1capa' . $font['id'] . ':nth-child(20):after {transform: translateZ(-28.5px);}';
            $style_font .=
                '.auxiliar1capa' .
                $font['id'] .
                " { width: 100%; height: 100%; position: absolute; transform-style: preserve-3d;
                                      animation: ಠ_ಠ 5s infinite alternate ease-in-out -7.5s;
                                      animation-fill-mode: forwards;
                                      transform: rotateY(10deg) rotateX(33deg) translateZ(0);}";
    
            $style_font .=
                ' .auxiliar1capa' .
                $font['id'] .
                ":after { white-space: pre; text-align: center; height: 100%;
                                      width: 100%;  position: absolute; top: 50px;letter-spacing: -2px; text-shadow: 4px 0 10px rgba(0, 0, 0, 0.13);}";
            $style_font .=
                '.auxiliar1capa' .
                $font['id'] .
                ":first-child:after { color: #fff; text-shadow: none; background: url('/img/texture.png') no-repeat center center;
                                    background-size: auto; background-clip: border-box; background-size: cover; -webkit-text-fill-color: transparent;
                                    -webkit-background-clip: text;}";
    
            $style_font .= '';
            echo $style_font;
        } else {
            $style_color_ok2 = str_replace('layer', 'auxiliar2capa' . $font['id'], $style_color);
            echo $style_color_ok2;
            $style_font = '@media only screen and (min-width: 360px) and (max-width: 768px) {';
            $style_color_ok3 = str_replace('-webkit-text-stroke: 15px', '-webkit-text-stroke: 9px', $style_color_ok2);
            $style_font .= $style_color_ok3;
            $style_font .= '}';
            $style_font .= '.auxiliar2capa' . $font['id'] . ':nth-child(1):after {}';
            $style_font .= '.auxiliar2capa' . $font['id'] . ':nth-child(2):after {transform: translateZ(-1.5px);}';
            $style_font .= '.auxiliar2capa' . $font['id'] . ':nth-child(3):after {transform: translateZ(-3px);}';
            $style_font .= '.auxiliar2capa' . $font['id'] . ':nth-child(4):after {transform: translateZ(-4.5px);}';
            $style_font .= '.auxiliar2capa' . $font['id'] . ':nth-child(5):after {transform: translateZ(-6px);}';
            $style_font .= '.auxiliar2capa' . $font['id'] . ':nth-child(6):after {transform: translateZ(-7.5px);}';
            $style_font .= '.auxiliar2capa' . $font['id'] . ':nth-child(7):after {transform: translateZ(-9px);}';
            $style_font .= '.auxiliar2capa' . $font['id'] . ':nth-child(8):after {transform: translateZ(-10.5px);}';
            $style_font .= '.auxiliar2capa' . $font['id'] . ':nth-child(9):after {transform: translateZ(-12px);}';
            $style_font .= '.auxiliar2capa' . $font['id'] . ':nth-child(10):after {transform: translateZ(-13.5px);}';
            $style_font .= '.auxiliar2capa' . $font['id'] . ':nth-child(11):after {transform: translateZ(-15px);}';
            $style_font .= '.auxiliar2capa' . $font['id'] . ':nth-child(12):after {transform: translateZ(-16.5px);}';
            $style_font .= '.auxiliar2capa' . $font['id'] . ':nth-child(13):after {transform: translateZ(-18px);}';
            $style_font .= '.auxiliar2capa' . $font['id'] . ':nth-child(14):after {transform: translateZ(-19.5px);}';
            $style_font .= '.auxiliar2capa' . $font['id'] . ':nth-child(15):after {transform: translateZ(-21px);}';
            $style_font .= '.auxiliar2capa' . $font['id'] . ':nth-child(16):after {transform: translateZ(-22.5px);}';
            $style_font .= '.auxiliar2capa' . $font['id'] . ':nth-child(17):after {transform: translateZ(-24px);}';
            $style_font .= '.auxiliar2capa' . $font['id'] . ':nth-child(18):after {transform: translateZ(-25.5px);}';
            $style_font .= '.auxiliar2capa' . $font['id'] . ':nth-child(19):after {transform: translateZ(-27px);}';
            $style_font .= '.auxiliar2capa' . $font['id'] . ':nth-child(20):after {transform: translateZ(-28.5px);}';
            $style_font .=
                '.auxiliar2capa' .
                $font['id'] .
                ":first-child:after {color: #fff; text-shadow: none;
                                          background: url('/img/texture.png') no-repeat center center; background-size: auto;
                                            background-clip: border-box; background-size: cover; -webkit-text-fill-color: transparent;
                                            -webkit-background-clip: text;}";
            $style_font .=
                '.auxiliar2capa' .
                $font['id'] .
                " { width: 100%; height: 100%; position: absolute; transform-style: preserve-3d;
                                            animation: ಠ_ಠ 5s infinite alternate ease-in-out -7.5s; animation-fill-mode: forwards;transform: rotateY(10deg) rotateX(5deg) translateZ(0);}";
    
            $style_font .=
                '.auxiliar2capa' .
                $font['id'] .
                ":after {white-space: pre; text-align: center; height: 100%; width: 100%;
                                          position: absolute; letter-spacing: -2px;";
            $style_font .= "content:'" . $order->design_name . "';";
            $style_font .= 'top:' . $font['top'] . ';';
            $style_font .= 'font-family:' . $font['font'] . ';';
            $style_font .= 'font-size:' . ($font['fontsize1'] - 7) . 'vw;';
            $style_font .= '}';
            echo $style_font;
        }
    }
    echo '</style>';
    ?>
    <div class="container-fluid">
        <div class="row">
            <div class="col-xs-12 col-sm-12" style="text-align: center;">
                <img src="/img/logo-avi.png" alt="" style="width: 100px; margin-bottom:10px;">
            </div>
        </div>
        <div class="row">
            <div class="col-xs-12 col-sm-12" style="text-align: center;">
                <div style="font-weight: 600; font-size:18px;">Font Wizard Pro Preview</div>
            </div>
        </div>
        <div class="row">
            <div class="col-xs-12" style="text-align: right; margin-bottom:10px">
                <button id="showmodal" type="button" class="btn"
                    style="background-color:rgb(33, 150, 243);height: 36px;width: 120px;margin-right: 10px; color: white;"
                    @click="sendpreview">Send Preview</button>
            </div>
        </div>
        <div class="btns" style="position:absolute;z-index:2">
            <button class="in" id="zoom_in">Zoom In</button>
            <button class="out" id="zoom_out">Zoom Out</button>
            <button class="reset" id="zoom_reset">Reset</button>
        </div>
        <?php
         if ($layer=='layer1') {                ?>
        <div class="row">
            <?php foreach ($fonts as $font) :?>
            <div class="col-xs-6 boxok">
                <div style="position: relative">

                    <div class="stage1">
                        <div class="auxiliar1capa<?php echo $font['id']; ?>"></div>
                        <div class="auxiliar1capa<?php echo $font['id']; ?>"></div>
                        <div class="auxiliar1capa<?php echo $font['id']; ?>"></div>
                        <div class="auxiliar1capa<?php echo $font['id']; ?>"></div>
                        <div class="auxiliar1capa<?php echo $font['id']; ?>"></div>
                        <div class="auxiliar1capa<?php echo $font['id']; ?>"></div>
                        <div class="auxiliar1capa<?php echo $font['id']; ?>"></div>
                        <div class="auxiliar1capa<?php echo $font['id']; ?>"></div>
                        <div class="auxiliar1capa<?php echo $font['id']; ?>"></div>
                        <div class="auxiliar1capa<?php echo $font['id']; ?>"></div>
                        <div class="auxiliar1capa<?php echo $font['id']; ?>"></div>
                        <div class="auxiliar1capa<?php echo $font['id']; ?>"></div>
                        <div class="auxiliar1capa<?php echo $font['id']; ?>"></div>
                        <div class="auxiliar1capa<?php echo $font['id']; ?>"></div>
                        <div class="auxiliar1capa<?php echo $font['id']; ?>"></div>
                        <div class="auxiliar1capa<?php echo $font['id']; ?>"></div>
                        <div class="auxiliar1capa<?php echo $font['id']; ?>"></div>
                        <div class="auxiliar1capa<?php echo $font['id']; ?>"></div>
                        <div class="auxiliar1capa<?php echo $font['id']; ?>"></div>
                        <div class="auxiliar1capa<?php echo $font['id']; ?>"></div>
                    </div>
                    <div style="font-size: 2vw; color: black;text-align: left;padding-bottom: 10px;">
                        <b>Font: </b>{{ $font['name'] }}
                    </div>
                </div>
            </div>
            <?php endforeach;?>
        </div>
        <?php
         } else {  ?>
        <div class="row " id="square">
            <?php foreach ($fonts as $font) :?>
            <div class="col-xs-6 boxok">
                <div style="position: relative">
                    <div class="stage ">
                        <div class="auxiliar2capa<?php echo $font['id']; ?>"></div>
                        <div class="auxiliar2capa<?php echo $font['id']; ?>"></div>
                        <div class="auxiliar2capa<?php echo $font['id']; ?>"></div>
                        <div class="auxiliar2capa<?php echo $font['id']; ?>"></div>
                        <div class="auxiliar2capa<?php echo $font['id']; ?>"></div>
                        <div class="auxiliar2capa<?php echo $font['id']; ?>"></div>
                        <div class="auxiliar2capa<?php echo $font['id']; ?>"></div>
                        <div class="auxiliar2capa<?php echo $font['id']; ?>"></div>
                        <div class="auxiliar2capa<?php echo $font['id']; ?>"></div>
                        <div class="auxiliar2capa<?php echo $font['id']; ?>"></div>
                        <div class="auxiliar2capa<?php echo $font['id']; ?>"></div>
                        <div class="auxiliar2capa<?php echo $font['id']; ?>"></div>
                        <div class="auxiliar2capa<?php echo $font['id']; ?>"></div>
                        <div class="auxiliar2capa<?php echo $font['id']; ?>"></div>
                        <div class="auxiliar2capa<?php echo $font['id']; ?>"></div>
                        <div class="auxiliar2capa<?php echo $font['id']; ?>"></div>
                        <div class="auxiliar2capa<?php echo $font['id']; ?>"></div>
                        <div class="auxiliar2capa<?php echo $font['id']; ?>"></div>
                        <div class="auxiliar2capa<?php echo $font['id']; ?>"></div>
                        <div class="auxiliar2capa<?php echo $font['id']; ?>"></div>
                    </div>
                    <div style="font-size: 2vw; color: black;text-align: left;padding-bottom: 10px;">
                        <b>Font : </b>{{ $font['name'] }}
                    </div>
                </div>
            </div>
            <?php endforeach;?>
            <div id="myModal" class="modal">
                <!-- Modal content -->
                <div class="modal-content magic box_modal" style="text-align: center;">
                    <span id="closemd" class="close" style="cursor: pointer;">&times;</span>
                    <br>
                    <h3 style="color: black">Share preview link </h3>
                    <br>
                    <div class="row">
                        <div class="col-xs-12">
                            <label for="phone">Phone: </label>
                            <input id="phoneval" name="phone" type="text" required
                                placeholder="(555) 555-5555" data-validation-type="phone"
                                style="line-height: 27px;margin-right:5px;text-align:center">
                        </div>
                        <div class="col-xs-12">
                            <button id="sendpreview" type="button" class="btn"
                                style="background-color:rgb(33, 150, 243);height: 36px;width: 120px;margin-right: 10px; color: white;margin-top:20px;margin-left:50px">Send
                                Preview</button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <?php
         }  ?>


    </div>
    <script src="{{ asset('assets/global/plugins/admin/js/vendor/jquery-1.11.2.min.js') }}"></script>
    <script>
        var btn = document.getElementById("sendpreview");
        var btnshow = document.getElementById("showmodal");
        var modal = document.getElementById("myModal");
        var span = document.getElementById("closemd");
        btnshow.onclick = function() {
            modal.style.display = "block";
            $('#phoneval').val("");
            document.getElementById('phoneval').addEventListener('input', function(e) {
                var x = e.target.value.replace(/\D/g, '').match(/(\d{0,3})(\d{0,3})(\d{0,4})/);
                e.target.value = !x[2] ? x[1] : '(' + x[1] + ') ' + x[2] + (x[3] ? '-' + x[3] : '');
            });
        }

        span.onclick = function() {
            modal.style.display = "none";
        }
        window.onclick = function(event) {
            if (event.target == modal) {
                modal.style.display = "none";
            }
        }

        btn.onclick = function() {
            var token = '{{ csrf_token() }}'; // ó $("#token").val() si lo tienes en una etiqueta html.
            var phone = $('#phoneval').val()
            var data = {
                phone: phone,
                url: window.location.href,
                _token: token
            };

            $.ajax({
                type: "post",
                url: "{{ url('web/function/sendPreviewAllLink') }}",
                data: data,
                success: function(datos) {
                    $('#phoneval').val("");
                    console.log(datos);
                    modal.style.display = "none";

                },
                error: function(result) {
                    alert("Error in SMS servicies");
                }
            });

            // When the user clicks anywhere outside of the modal, close it


        }
        jQuery(document).ready(function($) {
            // Set initial zoom level
            var zoom_level = 100;

            // Click events
            $('#zoom_in').click(function() {
                zoom_page(10, $(this))
            });
            $('#zoom_out').click(function() {
                zoom_page(-10, $(this))
            });
            $('#zoom_reset').click(function() {
                zoom_page(0, $(this))
            });

            // Zoom function
            function zoom_page(step, trigger) {
                // Zoom just to steps in or out
                if (zoom_level >= 140 && step > 0 || zoom_level <= 80 && step < 0) return;

                // Set / reset zoom
                if (step == 0) zoom_level = 100;
                else zoom_level = zoom_level + step;

                // Set page zoom via CSS
                $('#square').css({
                    transform: 'scale(' + (zoom_level / 100) + ')', // set zoom
                    transformOrigin: '50% 0' // set transform scale base
                });

                // Adjust page to zoom width
                if (zoom_level > 100) $('#square').css({
                    width: (zoom_level * 1.2) + '%'
                });
                else $('#square').css({
                    width: '100%'
                });

                // Activate / deaktivate trigger (use CSS to make them look different)
                if (zoom_level >= 120 || zoom_level <= 80) trigger.addClass('disabled');
                else trigger.parents('ul').find('.disabled').removeClass('disabled');
                if (zoom_level != 100) $('#zoom_reset').removeClass('disabled');
                else $('#zoom_reset').addClass('disabled');
            }
        });
    </script>
</body>

</html>
