<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Order Sent Successfully</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f4f4f4;
            margin: 0;
            padding: 0;
        }

        .container {
            max-width: 600px;
            margin: 50px auto;
            background-color: #fff;
            padding: 30px;
            border-radius: 10px;
            box-shadow: 0px 0px 15px rgba(0, 0, 0, 0.1);
            text-align: center;
        }

        .success-icon {
            font-size: 80px;
            color: #27ae60;
            margin-bottom: 20px;
        }

        h1 {
            color: #27ae60;
            /* Green color for success */
            text-align: center;
            margin-bottom: 20px;
            font-size: 2.5em;
        }

        .success-message {
            font-size: 1.2em;
            color: #555;
            margin-bottom: 30px;
            line-height: 1.6;
        }

        .order-info {
            background-color: #f8f9fa;
            padding: 20px;
            border-radius: 8px;
            margin: 20px 0;
            border-left: 4px solid #27ae60;
        }

        .order-info h3 {
            color: #333;
            margin-bottom: 15px;
            font-size: 1.3em;
        }

        .info-item {
            display: flex;
            justify-content: space-between;
            margin-bottom: 10px;
            padding: 8px 0;
            border-bottom: 1px solid #eee;
        }

        .info-item:last-child {
            border-bottom: none;
        }

        .info-label {
            font-weight: bold;
            color: #666;
        }

        .info-value {
            color: #333;
        }

        .next-steps {
            background-color: #e8f5e8;
            padding: 20px;
            border-radius: 8px;
            margin: 20px 0;
            border-left: 4px solid #27ae60;
        }

        .next-steps h3 {
            color: #27ae60;
            margin-bottom: 15px;
        }

        .next-steps ul {
            text-align: left;
            color: #555;
            line-height: 1.8;
        }

        .contact-info {
            margin-top: 30px;
            padding: 20px;
            background-color: #f8f9fa;
            border-radius: 8px;
        }

        .contact-info p {
            color: #666;
            margin-bottom: 10px;
        }

        .btn {
            display: inline-block;
            padding: 12px 25px;
            background-color: #27ae60;
            color: white;
            text-decoration: none;
            border-radius: 5px;
            margin: 10px;
            transition: background-color 0.3s ease;
        }

        .btn:hover {
            background-color: #219a52;
        }

        /* Responsive Design for Mobile Devices */
        @media (max-width: 768px) {
            .container {
                margin: 10px;
                padding: 15px;
                max-width: calc(100% - 20px);
            }

            h1 {
                font-size: 1.8em;
                margin-bottom: 15px;
            }

            .success-icon {
                font-size: 50px;
                margin-bottom: 15px;
            }

            .success-message {
                font-size: 1.1em;
                margin-bottom: 20px;
            }

            .order-info {
                padding: 15px;
                margin: 15px 0;
            }

            .order-info h3 {
                font-size: 1.2em;
                margin-bottom: 12px;
            }

            .info-item {
                flex-direction: column;
                align-items: flex-start;
                padding: 10px 0;
            }

            .info-label {
                margin-bottom: 5px;
                font-size: 0.9em;
            }

            .info-value {
                font-size: 1em;
                word-break: break-all;
            }

            .next-steps {
                padding: 15px;
                margin: 15px 0;
            }

            .next-steps h3 {
                font-size: 1.2em;
                margin-bottom: 12px;
            }

            .next-steps ul {
                font-size: 0.95em;
                padding-left: 20px;
            }

            .contact-info {
                padding: 15px;
                margin-top: 20px;
            }

            .btn {
                display: block;
                width: 100%;
                margin: 10px 0;
                padding: 15px;
                font-size: 1em;
                text-align: center;
            }
        }

        @media (max-width: 480px) {
            .container {
                margin: 5px;
                padding: 10px;
                max-width: calc(100% - 10px);
            }

            h1 {
                font-size: 1.5em;
                margin-bottom: 12px;
            }

            .success-icon {
                font-size: 40px;
                margin-bottom: 12px;
            }

            .success-message {
                font-size: 1em;
                margin-bottom: 15px;
            }

            .order-info {
                padding: 12px;
                margin: 12px 0;
            }

            .order-info h3 {
                font-size: 1.1em;
                margin-bottom: 10px;
            }

            .info-item {
                padding: 8px 0;
            }

            .info-label {
                font-size: 0.85em;
            }

            .info-value {
                font-size: 0.95em;
            }

            .next-steps {
                padding: 12px;
                margin: 12px 0;
            }

            .next-steps h3 {
                font-size: 1.1em;
                margin-bottom: 10px;
            }

            .next-steps ul {
                font-size: 0.9em;
                padding-left: 18px;
            }

            .contact-info {
                padding: 12px;
                margin-top: 15px;
            }

            .btn {
                padding: 12px;
                font-size: 0.95em;
            }
        }

        @media (max-width: 360px) {
            .container {
                margin: 2px;
                padding: 8px;
                max-width: calc(100% - 4px);
            }

            h1 {
                font-size: 1.3em;
                margin-bottom: 10px;
            }

            .success-icon {
                font-size: 35px;
                margin-bottom: 10px;
            }

            .success-message {
                font-size: 0.95em;
                margin-bottom: 12px;
            }

            .order-info {
                padding: 10px;
                margin: 10px 0;
            }

            .order-info h3 {
                font-size: 1em;
                margin-bottom: 8px;
            }

            .info-item {
                padding: 6px 0;
            }

            .info-label {
                font-size: 0.8em;
            }

            .info-value {
                font-size: 0.9em;
            }

            .next-steps {
                padding: 10px;
                margin: 10px 0;
            }

            .next-steps h3 {
                font-size: 1em;
                margin-bottom: 8px;
            }

            .next-steps ul {
                font-size: 0.85em;
                padding-left: 15px;
            }

            .contact-info {
                padding: 10px;
                margin-top: 12px;
            }

            .btn {
                padding: 10px;
                font-size: 0.9em;
            }
        }
    </style>
</head>

<body>
    <div class="container">
        <div class="success-icon">✓</div>
        <h1>Order Sent Successfully!</h1>

        <p class="success-message">
            Thank you for your order! Your font design request has been successfully submitted and our team has been
            notified.
        </p>

        <div class="order-info">
            <h3>Order Details</h3>
            <div class="info-item">
                <span class="info-label">Order ID:</span>
                <span class="info-value">#{{ $orderId ?? 'ORD-' . date('YmdHis') }}</span>
            </div>
            <div class="info-item">
                <span class="info-label">Date:</span>
                <span class="info-value">{{ date('M d, Y \a\t g:i A') }}</span>
            </div>
            <div class="info-item">
                <span class="info-label">Status:</span>
                <span class="info-value" style="color: #27ae60; font-weight: bold;">In Progress</span>
            </div>

        </div>

        <div class="next-steps">
            <h3>What happens next?</h3>
            <ul>
                <li>Our design team will review your specifications</li>
                <li>We'll create your custom font design</li>
                <li>You'll receive a preview for approval</li>
                <li>Final design will be delivered via email</li>
            </ul>
        </div>


    </div>
</body>

</html>
