<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <title>@yield('title', 'Font Admin') - {{ config('app.name', 'Fonts Wizard') }}</title>

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.bunny.net">
    <link href="https://fonts.bunny.net/css?family=figtree:400,500,600&display=swap" rel="stylesheet" />

    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">

    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">

    <!-- Custom Fonts -->
    <link rel="stylesheet"
        href="{{ asset('fonts/custom/stylesheet.css') }}?v={{ file_exists(public_path('fonts/custom/stylesheet.css')) ? filemtime(public_path('fonts/custom/stylesheet.css')) : time() }}">

    <!-- Custom CSS -->
    <style>
        .sidebar {
            min-height: 100vh;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            box-shadow: 2px 0 10px rgba(0, 0, 0, 0.1);
            transition: transform 0.3s ease;
        }

        .sidebar.collapsed {
            transform: translateX(-100%);
        }

        .sidebar .nav-link {
            color: rgba(255, 255, 255, 0.8);
            padding: 12px 20px;
            border-radius: 8px;
            margin: 5px 10px;
            transition: all 0.3s ease;
        }

        .sidebar .nav-link:hover,
        .sidebar .nav-link.active {
            color: white;
            background: rgba(255, 255, 255, 0.1);
            transform: translateX(5px);
        }

        .sidebar .nav-link i {
            margin-right: 10px;
            width: 20px;
        }

        .main-content {
            background-color: #f8f9fa;
            min-height: 100vh;
            transition: margin-left 0.3s ease;
        }

        .main-content.expanded {
            margin-left: 0;
        }

        .navbar-brand {
            font-weight: 600;
            color: #667eea !important;
        }

        .card {
            border: none;
            border-radius: 15px;
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.08);
        }

        .btn-primary {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            border: none;
            border-radius: 8px;
            padding: 10px 20px;
        }

        .btn-primary:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(102, 126, 234, 0.4);
        }

        .table {
            background: white;
            border-radius: 10px;
            overflow: hidden;
            box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);
        }

        .table th {
            background: #667eea;
            color: white;
            border: none;
            font-weight: 500;
            padding: 15px 12px;
        }

        .table td {
            padding: 12px;
            vertical-align: middle;
            border-top: 1px solid #f1f3f4;
        }

        .table tbody tr:hover {
            background-color: #f8f9fa;
        }

        .font-preview {
            font-size: 14px !important;
            font-weight: bold;
            color: #667eea;
            text-align: center;
            padding: 6px 10px;
            background: #f8f9fa;
            border-radius: 6px;
            border: 1px solid #e9ecef;
            min-height: 35px;
            display: flex;
            align-items: center;
            justify-content: center;
            max-width: 100px;
            overflow: hidden;
            text-overflow: ellipsis;
            white-space: nowrap;
        }

        .clickable-preview {
            cursor: pointer;
            transition: all 0.3s ease;
        }

        .clickable-preview:hover {
            background: #e9ecef;
            border-color: #667eea;
            transform: scale(1.05);
            box-shadow: 0 2px 8px rgba(102, 126, 234, 0.3);
        }

        .status-badge {
            padding: 5px 12px;
            border-radius: 20px;
            font-size: 12px;
            font-weight: 500;
        }

        .status-active {
            background: #d4edda;
            color: #155724;
        }

        .status-inactive {
            background: #f8d7da;
            color: #721c24;
        }

        .btn-group .btn {
            margin-right: 5px;
        }

        .btn-group .btn:last-child {
            margin-right: 0;
        }

        .action-buttons {
            display: flex;
            gap: 5px;
            flex-wrap: wrap;
        }

        .action-buttons .btn {
            margin: 0;
        }

        .sidebar-toggle {
            position: fixed;
            top: 20px;
            left: 20px;
            z-index: 1050;
            background: #667eea;
            border: none;
            color: white;
            padding: 10px;
            border-radius: 8px;
            box-shadow: 0 2px 8px rgba(0, 0, 0, 0.2);
        }

        .sidebar-toggle:hover {
            background: #5a6fd8;
        }

        .preview-container {
            background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
            border-radius: 12px;
            padding: 20px;
            min-height: 200px;
            display: flex;
            align-items: center;
            justify-content: center;
            border: 2px dashed #dee2e6;
        }

        .font-preview-large {
            font-size: 24px;
            font-weight: bold;
            color: #667eea;
            text-align: center;
            padding: 20px;
            background: white;
            border-radius: 8px;
            box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);
            min-height: 100px;
            display: flex;
            align-items: center;
            justify-content: center;
            word-wrap: break-word;
            max-width: 100%;
            transition: all 0.3s ease;
        }

        .font-preview-large:hover {
            transform: scale(1.02);
            box-shadow: 0 4px 16px rgba(0, 0, 0, 0.15);
        }

        /* Controls Section */
        .controls-section {
            display: flex;
            gap: 20px;
            margin-bottom: 20px;
            padding: 20px;
            background: #f8f9fa;
            border-radius: 12px;
            border: 1px solid #e9ecef;
        }

        .control-group {
            flex: 1;
            display: flex;
            flex-direction: column;
            gap: 8px;
        }

        .control-label {
            font-weight: 600;
            color: #495057;
            font-size: 14px;
            margin-bottom: 0;
            display: flex;
            align-items: center;
        }

        .control-input {
            border: 2px solid #e9ecef;
            border-radius: 8px;
            padding: 10px 12px;
            font-size: 14px;
            transition: all 0.3s ease;
        }

        .control-input:focus {
            border-color: #667eea;
            box-shadow: 0 0 0 3px rgba(102, 126, 234, 0.1);
        }

        .size-control {
            display: flex;
            align-items: center;
            gap: 12px;
        }

        .size-value {
            background: #667eea;
            color: white;
            padding: 4px 8px;
            border-radius: 6px;
            font-size: 12px;
            font-weight: 600;
            min-width: 50px;
            text-align: center;
        }

        .color-control {
            display: flex;
            align-items: center;
            gap: 12px;
        }

        .color-value {
            background: #f8f9fa;
            color: #495057;
            padding: 4px 8px;
            border-radius: 6px;
            font-size: 12px;
            font-weight: 600;
            min-width: 70px;
            text-align: center;
            border: 1px solid #e9ecef;
        }

        /* Preview Section */
        .preview-section {
            flex: 1;
            display: flex;
            flex-direction: column;
        }

        .preview-container-fullscreen {
            background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
            border-radius: 15px;
            padding: 30px;
            flex: 1;
            display: flex;
            align-items: center;
            justify-content: center;
            border: 3px dashed #dee2e6;
            min-height: 0;
        }

        .font-preview-fullscreen {
            font-size: 48px;
            font-weight: bold;
            color: #667eea;
            text-align: center;
            padding: 30px;
            background: white;
            border-radius: 15px;
            box-shadow: 0 8px 32px rgba(0, 0, 0, 0.1);
            min-height: 150px;
            display: flex;
            align-items: center;
            justify-content: center;
            word-wrap: break-word;
            max-width: 100%;
            width: 100%;
            transition: all 0.3s ease;
            border: 2px solid #e9ecef;
        }

        .font-preview-fullscreen:hover {
            transform: scale(1.01);
            box-shadow: 0 12px 48px rgba(0, 0, 0, 0.15);
            border-color: #667eea;
        }

        /* Fullscreen Modal Styles */
        .modal-fullscreen .modal-content {
            border-radius: 0;
            border: none;
            height: 100vh;
            display: flex;
            flex-direction: column;
        }

        .modal-fullscreen .modal-header {
            border-radius: 0;
            flex-shrink: 0;
        }

        .modal-fullscreen .modal-body {
            flex: 1;
            overflow: hidden;
            padding: 20px;
            display: flex;
            flex-direction: column;
        }

        .modal-fullscreen .modal-footer {
            border-radius: 0;
            flex-shrink: 0;
        }

        /* Custom Pagination Styles */
        .custom-pagination-wrapper {
            background: white;
            border-radius: 15px;
            padding: 25px;
            margin-top: 25px;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
            border: 1px solid #f1f3f4;
        }

        .custom-pagination {
            display: flex;
            justify-content: center;
            align-items: center;
            gap: 8px;
            margin-top: 15px;
        }

        .pagination-btn {
            display: inline-flex;
            align-items: center;
            justify-content: center;
            min-width: 40px;
            height: 40px;
            padding: 0 12px;
            background: white;
            border: 2px solid #e9ecef;
            border-radius: 10px;
            color: #667eea;
            text-decoration: none;
            font-weight: 600;
            font-size: 14px;
            transition: all 0.3s ease;
            cursor: pointer;
        }

        .pagination-btn:hover {
            background: #667eea;
            border-color: #667eea;
            color: white;
            transform: translateY(-2px);
            box-shadow: 0 6px 16px rgba(102, 126, 234, 0.3);
            text-decoration: none;
        }

        .pagination-btn.active {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            border-color: #667eea;
            color: white;
            box-shadow: 0 4px 12px rgba(102, 126, 234, 0.4);
        }

        .pagination-btn.disabled {
            background: #f8f9fa;
            border-color: #e9ecef;
            color: #adb5bd;
            cursor: not-allowed;
            transform: none;
        }

        .pagination-btn.disabled:hover {
            background: #f8f9fa;
            border-color: #e9ecef;
            color: #adb5bd;
            transform: none;
            box-shadow: none;
        }

        .pagination-dots {
            display: inline-flex;
            align-items: center;
            justify-content: center;
            min-width: 40px;
            height: 40px;
            color: #6c757d;
            font-weight: 600;
            font-size: 16px;
        }

        .pagination-info {
            text-align: center;
            color: #6c757d;
            font-size: 14px;
            font-weight: 500;
            margin-bottom: 0;
        }

        /* Override Laravel Default Pagination */
        .pagination {
            display: none !important;
        }

        .page-link {
            display: none !important;
        }

        .page-item {
            display: none !important;
        }

        .modal-content {
            border-radius: 15px;
            border: none;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.2);
        }

        .modal-header {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            border-radius: 15px 15px 0 0;
            border: none;
        }

        .modal-header .btn-close {
            filter: invert(1);
        }

        .form-control-color {
            width: 60px;
            height: 38px;
            border: none;
            border-radius: 8px;
            cursor: pointer;
        }

        .form-range {
            cursor: pointer;
        }

        .form-range::-webkit-slider-thumb {
            background: #667eea;
            border: none;
            border-radius: 50%;
            width: 20px;
            height: 20px;
        }

        .form-range::-moz-range-thumb {
            background: #667eea;
            border: none;
            border-radius: 50%;
            width: 20px;
            height: 20px;
        }

        @media (max-width: 768px) {
            .sidebar {
                position: fixed;
                z-index: 1040;
                width: 280px;
            }

            .main-content {
                margin-left: 0;
            }

            .table-responsive {
                font-size: 14px;
            }

            .font-preview {
                font-size: 12px !important;
                max-width: 80px;
                padding: 4px 6px;
            }

            .modal-dialog {
                margin: 10px;
            }

            .preview-container {
                min-height: 150px;
                padding: 15px;
            }

            .font-preview-large {
                font-size: 18px;
                padding: 15px;
            }

            .controls-section {
                flex-direction: column;
                gap: 15px;
                padding: 15px;
            }

            .control-group {
                gap: 6px;
            }

            .size-control,
            .color-control {
                gap: 8px;
            }

            .size-value,
            .color-value {
                font-size: 11px;
                padding: 3px 6px;
            }

            .preview-container-fullscreen {
                padding: 20px;
            }

            .font-preview-fullscreen {
                font-size: 32px;
                padding: 20px;
                min-height: 120px;
            }

            .modal-fullscreen .modal-body {
                padding: 15px;
            }

            /* Responsive Custom Pagination */
            .custom-pagination-wrapper {
                padding: 20px;
                margin-top: 20px;
            }

            .custom-pagination {
                gap: 6px;
            }

            .pagination-btn {
                min-width: 36px;
                height: 36px;
                padding: 0 10px;
                font-size: 13px;
            }

            .pagination-dots {
                min-width: 36px;
                height: 36px;
                font-size: 14px;
            }

            .pagination-info {
                font-size: 13px;
            }
        }
    </style>
</head>

<body>
    <!-- Sidebar Toggle Button -->
    <button class="sidebar-toggle" id="sidebarToggle">
        <i class="fas fa-bars"></i>
    </button>

    <div class="container-fluid">
        <div class="row">
            <!-- Sidebar -->
            <nav class="col-md-3 col-lg-2 d-md-block sidebar collapse" id="sidebar">
                <div class="position-sticky pt-3">
                    <div class="text-center mb-4">
                        <h4 class="text-white">
                            <i class="fas fa-font"></i>
                            Font Admin
                        </h4>
                    </div>

                    <ul class="nav flex-column">
                        <li class="nav-item">
                            <a class="nav-link {{ request()->routeIs('admin.dashboard') ? 'active' : '' }}"
                                href="{{ route('admin.dashboard') }}">
                                <i class="fas fa-tachometer-alt"></i>
                                Dashboard
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link {{ request()->routeIs('admin.fonts.*') ? 'active' : '' }}"
                                href="{{ route('admin.fonts.index') }}">
                                <i class="fas fa-font"></i>
                                Manage Fonts
                            </a>
                        </li>
                        <li class="nav-item mt-4">
                            <a class="nav-link" href="{{ route('App') }}">
                                <i class="fas fa-external-link-alt"></i>
                                Back to App
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="{{ route('logout') }}"
                                onclick="event.preventDefault(); document.getElementById('logout-form').submit();">
                                <i class="fas fa-sign-out-alt"></i>
                                Logout
                            </a>
                        </li>
                    </ul>
                </div>
            </nav>

            <!-- Main content -->
            <main class="col-md-9 ms-sm-auto col-lg-10 px-md-4 main-content" id="mainContent">
                <!-- Top Navigation -->
                <div
                    class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
                    <h1 class="h2">@yield('page-title', 'Admin Panel')</h1>
                    <div class="btn-toolbar mb-2 mb-md-0">
                        <div class="btn-group me-2">
                            <span class="text-muted">Welcome, {{ Auth::user()->name }}</span>
                        </div>
                    </div>
                </div>

                <!-- Flash Messages -->
                @if (session('success'))
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        <i class="fas fa-check-circle me-2"></i>
                        {{ session('success') }}
                        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                    </div>
                @endif

                @if (session('error'))
                    <div class="alert alert-danger alert-dismissible fade show" role="alert">
                        <i class="fas fa-exclamation-circle me-2"></i>
                        {{ session('error') }}
                        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                    </div>
                @endif

                <!-- Page Content -->
                @yield('content')
            </main>
        </div>
    </div>

    <!-- Logout Form -->
    <form id="logout-form" action="{{ route('logout') }}" method="POST" class="d-none">
        @csrf
    </form>

    <!-- Font Preview Modal -->
    <div class="modal fade" id="fontPreviewModal" tabindex="-1" aria-labelledby="fontPreviewModalLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-fullscreen">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="fontPreviewModalLabel">
                        <i class="fas fa-font me-2"></i>
                        Font Preview
                    </h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <!-- Controls Section -->
                    <div class="controls-section">
                        <div class="control-group">
                            <label for="previewText" class="control-label">
                                <i class="fas fa-font me-2"></i>
                                Preview Text
                            </label>
                            <textarea class="form-control control-input" id="previewText" rows="2" placeholder="Enter text to preview...">Example Text</textarea>
                        </div>

                        <div class="control-group">
                            <label for="fontSize" class="control-label">
                                <i class="fas fa-text-height me-2"></i>
                                Font Size
                            </label>
                            <div class="size-control">
                                <input type="range" class="form-range" id="fontSize" min="8" max="50"
                                    value="18">
                                <span class="size-value" id="fontSizeValue">18vw</span>
                            </div>
                        </div>

                        <div class="control-group">
                            <label for="fontColor" class="control-label">
                                <i class="fas fa-palette me-2"></i>
                                Font Color
                            </label>
                            <div class="color-control">
                                <input type="color" class="form-control form-control-color" id="fontColor"
                                    value="#667eea">
                                <span class="color-value" id="fontColorValue">#667eea</span>
                            </div>
                        </div>
                    </div>

                    <!-- Preview Section -->
                    <div class="preview-section">
                        <div class="preview-container-fullscreen">
                            <div class="font-preview-fullscreen" id="modalFontPreview">
                                Example Text
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">
                        <i class="fas fa-times me-2"></i>
                        Close
                    </button>
                    <button type="button" class="btn btn-primary" id="copyStyle">
                        <i class="fas fa-copy me-2"></i>
                        Copy CSS
                    </button>
                </div>
            </div>
        </div>
    </div>

    <!-- Simple Test Modal -->
    <div class="modal fade" id="testModal" tabindex="-1" aria-labelledby="testModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="testModalLabel">Test Modal</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <p>This is a test modal to verify Bootstrap modals are working.</p>
                    <p id="testModalContent">Font information will appear here.</p>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                </div>
            </div>
        </div>
    </div>

    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>

    <!-- Custom JS -->
    <script>
        // Auto-hide alerts after 5 seconds
        setTimeout(function() {
            const alerts = document.querySelectorAll('.alert');
            alerts.forEach(function(alert) {
                const bsAlert = new bootstrap.Alert(alert);
                bsAlert.close();
            });
        }, 5000);

        // Sidebar toggle functionality
        document.addEventListener('DOMContentLoaded', function() {
            const sidebarToggle = document.getElementById('sidebarToggle');
            const sidebar = document.getElementById('sidebar');
            const mainContent = document.getElementById('mainContent');
            let sidebarCollapsed = false;

            sidebarToggle.addEventListener('click', function() {
                sidebarCollapsed = !sidebarCollapsed;

                if (sidebarCollapsed) {
                    sidebar.classList.add('collapsed');
                    mainContent.classList.add('expanded');
                    sidebarToggle.innerHTML = '<i class="fas fa-bars"></i>';
                } else {
                    sidebar.classList.remove('collapsed');
                    mainContent.classList.remove('expanded');
                    sidebarToggle.innerHTML = '<i class="fas fa-times"></i>';
                }
            });

            // Close sidebar on mobile when clicking outside
            document.addEventListener('click', function(e) {
                if (window.innerWidth <= 768 && !sidebarCollapsed) {
                    if (!sidebar.contains(e.target) && !sidebarToggle.contains(e.target)) {
                        sidebarCollapsed = true;
                        sidebar.classList.add('collapsed');
                        mainContent.classList.add('expanded');
                        sidebarToggle.innerHTML = '<i class="fas fa-bars"></i>';
                    }
                }
            });
        });

        // Font Preview Modal functionality
        let currentFontStyle = '';
        let currentFontName = '';

        // Function to open font preview modal
        window.openFontPreview = function(fontStyle, fontName, displayName) {
            console.log('Opening font preview:', fontName, displayName);

            currentFontStyle = fontStyle;
            currentFontName = fontName;

            // Update modal title
            const modalTitle = document.getElementById('fontPreviewModalLabel');
            if (modalTitle) {
                modalTitle.innerHTML = '<i class="fas fa-font me-2"></i>Font Preview: ' + displayName;
            }

            // Reset controls
            const previewText = document.getElementById('previewText');
            const fontSize = document.getElementById('fontSize');
            const fontSizeValue = document.getElementById('fontSizeValue');
            const fontColor = document.getElementById('fontColor');

            if (previewText) previewText.value = 'Example Text';
            if (fontSize) fontSize.value = 18;
            if (fontSizeValue) fontSizeValue.textContent = '18vw';
            if (fontColor) fontColor.value = '#667eea';

            // Apply initial style
            updateModalPreview();

            // Show modal
            const modalElement = document.getElementById('fontPreviewModal');
            if (modalElement) {
                const modal = new bootstrap.Modal(modalElement);
                modal.show();
                console.log('Modal should be showing now');
            } else {
                console.error('Modal element not found');
            }
        };

        // Function to update preview
        function updateModalPreview() {
            const previewElement = document.getElementById('modalFontPreview');
            const textElement = document.getElementById('previewText');
            const sizeElement = document.getElementById('fontSize');
            const colorElement = document.getElementById('fontColor');

            if (!previewElement) return;

            const text = textElement ? textElement.value : 'Example Text';
            const size = sizeElement ? sizeElement.value : 18;
            const color = colorElement ? colorElement.value : '#667eea';

            // Extract font-family from current style
            const fontFamily = currentFontName ? `'${currentFontName}', Arial, sans-serif` : 'Arial, sans-serif';

            // Create new style for fullscreen preview
            const newStyle =
                `font-family: ${fontFamily}; font-size: ${size}vw; color: ${color}; text-align: center; height:100%; width: 100%; display: flex; align-items: center; justify-content: center; word-wrap: break-word;`;

            previewElement.style.cssText = newStyle;
            previewElement.textContent = text;

            // Update size display
            const sizeValueElement = document.getElementById('fontSizeValue');
            if (sizeValueElement) {
                sizeValueElement.textContent = size + 'vw';
            }

            // Update color display
            const colorValueElement = document.getElementById('fontColorValue');
            if (colorValueElement) {
                colorValueElement.textContent = color;
            }
        }

        // Event listeners for modal controls
        document.addEventListener('DOMContentLoaded', function() {
            const previewText = document.getElementById('previewText');
            const fontSize = document.getElementById('fontSize');
            const fontColor = document.getElementById('fontColor');
            const copyStyleBtn = document.getElementById('copyStyle');

            if (previewText) {
                previewText.addEventListener('input', updateModalPreview);
            }

            if (fontSize) {
                fontSize.addEventListener('input', updateModalPreview);
            }

            if (fontColor) {
                fontColor.addEventListener('change', updateModalPreview);
            }

            if (copyStyleBtn) {
                copyStyleBtn.addEventListener('click', function() {
                    const previewElement = document.getElementById('modalFontPreview');
                    const computedStyle = window.getComputedStyle(previewElement);

                    const cssText =
                        `font-family: ${computedStyle.fontFamily}; font-size: ${computedStyle.fontSize}; color: ${computedStyle.color};`;

                    navigator.clipboard.writeText(cssText).then(function() {
                        // Show success message
                        const btn = copyStyleBtn;
                        const originalText = btn.innerHTML;
                        btn.innerHTML = '<i class="fas fa-check me-2"></i>Copied!';
                        btn.classList.remove('btn-primary');
                        btn.classList.add('btn-success');

                        setTimeout(function() {
                            btn.innerHTML = originalText;
                            btn.classList.remove('btn-success');
                            btn.classList.add('btn-primary');
                        }, 2000);
                    });
                });
            }
        });
    </script>

    @yield('scripts')
</body>

</html>
