<!DOCTYPE html>
<!--[if IE 8]> <html lang="en" class="ie8 no-js"> <![endif]-->
<!--[if IE 9]> <html lang="en" class="ie9 no-js"> <![endif]-->
<!--[if !IE]><!-->
<html lang="{{ app()->getLocale() }}">
<!--<![endif]-->
<!-- BEGIN HEAD -->

<head>
    <style>
        .modal {
            display: none;
            /* Hidden by default */
            position: fixed;
            /* Stay in place */
            z-index: 100;
            /* Sit on top */
            left: 0;
            top: 10%;
            width: 100%;
            /* Full width */
            height: 100%;
            /* Full height */
            overflow: auto;
            /* Enable scroll if needed */
            background-color: rgb(0, 0, 0);
            /* Fallback color */
            background-color: rgba(0, 0, 0, 0.4);
            /* Black w/ opacity */
        }

        .box_modal {
            box-shadow: rgba(0, 0, 0, 0.35) 0px 5px 15px;
            border-radius: 25px;
        }

        .btn_copy {
            background-color: rgb(33, 150, 243);

            width: 135px;
            height: 35px;
            vertical-align: inherit;
            vertical-align: middle;
            text-align: center;
            border: 1px solid transparent;
            font-size: 12px;
            font-weight: 600;
            text-transform: uppercase;
            border-radius: 2px;
            overflow: hidden;
            position: relative;
            padding: 8px 14px 7px;
        }

        /* Modal Content/Box */
        .modal-content {
            background-color: #fefefe;
            margin: 15% auto;
            /* 15% from the top and centered */
            padding: 20px;
            border: 1px solid #888;
            width: 80%;
            /* Could be more or less, depending on screen size */
        }

        /* The Close Button */
        .close {
            color: #aaa;
            float: right;
            font-size: 28px;
            font-weight: bold;
        }

        .close:hover,
        .close:focus {
            color: black;
            text-decoration: none;
            cursor: pointer;
        }
    </style>

    <meta http-equiv="content-type" content="text/html; charset=UTF-8">
    <meta charset="utf-8">

    <!-- Page Title Here -->
    <title>Font Wizar Pro - Avi the Jeweler</title>

    <!-- Page Description Here -->
    <meta name="description"
        content="A responsive coming soon template, un template HTML pour une page en cours de construction">

    <!-- Disable screen scaling-->
    <meta name="viewport"
        content="width=device-width, user-scalable=no, initial-scale=1, maximum-scale=1, user-scalable=0">

    <!-- Place favicon.ico and apple-touch-icon(s) in the root directory -->

    <!-- Initializer -->
    <link rel="stylesheet" href="{{ asset('assets/global/plugins/admin/css/normalize.css') }}">

    <!-- Web fonts and Web Icons -->
    <link rel="stylesheet" href="{{ asset('assets/global/plugins/admin/css/pageloader.css') }}">
    <link rel="stylesheet" href="{{ asset('assets/global/plugins/admin/fonts/opensans/stylesheet.css') }}">
    <link rel="stylesheet" href="{{ asset('assets/global/plugins/admin/fonts/asap/stylesheet.css') }}">
    <link rel="stylesheet" href="{{ asset('assets/global/plugins/admin/css/ionicons.min.css') }}">

    <!-- Vendor CSS style -->
    <link rel="stylesheet" href="{{ asset('assets/global/plugins/admin/css/foundation.min.css') }}">
    <link rel="stylesheet" href="{{ asset('assets/global/plugins/admin/js/vendor/jquery.fullPage.css') }}">
    <link rel="stylesheet" href="{{ asset('assets/global/plugins/admin/js/vegas/vegas.min.css') }}">

    <!-- Main CSS files -->
    <link rel="stylesheet" href="{{ asset('assets/global/plugins/admin/css/main.css') }}">
    <link rel="stylesheet" href="{{ asset('assets/global/plugins/admin/css/main_responsive.css') }}">
    <link rel="stylesheet" href="{{ asset('assets/global/plugins/admin/css/style-color1.css') }}">

    <script src="{{ asset('assets/global/plugins/admin/js/vendor/modernizr-2.7.1.min.js') }}"></script>
</head>

<body id="menu" class="alt-bg">
    <!--[if lt IE 8]>
            <p class="browsehappy">You are using an <strong>outdated</strong> browser. Please <a href="http://browsehappy.com/">upgrade your browser</a> to improve your experience.</p>
        <![endif]-->

    <!-- Page Loader -->
    <div class="page-loader" id="page-loader">
        <div><i class="ion ion-loading-d"></i>
            <p>loading</p>
        </div>
    </div>

    <!-- BEGIN OF site header Menu -->
    <!-- Add "material" class for a material design style -->
    <header class="header-top">

        <div class="menu clearfix">
            <a href="#about-us">about</a>

            <!--<div class="menu-cont">
     <p class="text">Menu cont</p>
     <ul class="sub-menu">
      <li><a href="htp://page">My Page</a></li>
     </ul>
    </div>-->
            <!-- Add other menu similar to "about" here -->
            <a href="#contact">contact</a>
        </div>
    </header>
    <!-- END OF site header Menu-->

    <!-- BEGIN OF Quick nav icons at left -->
    <nav class="quick-link count-4 nav-left">
        <div class="logo">
            <a href="#home">
                <img src="{{ asset('assets/global/plugins/admin/img/logo-avi.png') }}" alt="Logo Brand">
            </a>
        </div>
        <ul id="qmenu" class="qmenu">
            <li data-menuanchor="home">
                <a href="#home" class=""><i class="icon ion ion-home"></i>
                </a>
                <span class="title">Local Wizard</span>
            </li>
            <li data-menuanchor="register">
                <a href="#register"><i class="icon ion ion-compose"></i>
                </a>
                <span class="title">Share Wizard</span>
            </li>
            <li data-menuanchor="about-us">
                <a href="#about-us"><i class="icon ion ion-android-information"></i>
                </a>
                <span class="title">About Us</span>
            </li>
            <!--<li data-menuanchor="contact">
     <a href="#contact"><i class="icon ion ion-android-call"></i>
     </a>
     <span class="title">Contact</span>
    </li>-->
            <li data-menuanchor="contact">
                <a href="#contact"><i class="icon ion ion-email"></i>
                </a>
                <span class="title">Contact</span>
            </li>
            <li>
                <a href="{{ route('logout') }}"
                    onclick="event.preventDefault();
										 document.getElementById('logout-form').submit();"
                    alt="Logout">
                    <i class="icon ion ion-log-out"></i>
                </a>

                <form id="logout-form" action="{{ route('logout') }}" method="POST" style="display: none;">
                    {{ csrf_field() }}
                </form>

            </li>
        </ul>
    </nav>
    <!-- END OF Quick nav icons at left -->



    <!-- BEGIN OF site cover -->
    <div class="page-cover" id="s-cover">
        <!-- Cover Background -->
        <div class="cover-bg pos-abs full-size bg-img"
            data-image-src="{{ asset('assets/global/plugins/admin/img/back-font-wizard.jpg') }}"></div>

        <!-- BEGIN OF Slideshow Background -->
        <!--<div class="cover-bg pos-abs full-size slide-show">
    <i class='img' data-src='./img/bg-slide1.jpg'></i>
    <i class='img' data-src='./img/bg-slide2.jpg'></i>
    <i class='img' data-src='./img/bg-slide3.jpg'></i>
    <i class='img' data-src='./img/bg-slide4.jpg'></i>
   </div>-->
        <!-- END OF Slideshow Background -->

        <!--BEGIN OF Static video bg  - uncomment below to use Video as Background-->
        <!--<div id="container" class="video-container show-for-medium-up">
                <video autoplay="autoplay" loop="loop" autobuffer="autobuffer" muted="muted"
                       width="640" height="360">
                    <source src="vid/flower_loop.mp4" type="video/mp4">
                </video>
            </div>-->
        <!--END OF Static video bg-->

        <!-- Solid color as background -->
        <!--            <div class="cover-bg pos-abs full-size bg-color" data-bgcolor="rgb(59, 59, 59)"></div>-->

        <!-- Solid color as filter -->
        <div class="cover-bg-mask pos-abs full-size bg-color" data-bgcolor="rgba(0, 0, 0, 0.41)"></div>

    </div>
    <!--END OF site Cover -->

    <!-- Begin of timer pane -->
    <div class="pane-when " id="s-when">
        <div class="content">
            <!-- Clock -->
            <div class="clock clock-countdown">
                <div class="site-config" data-date="12/31/2017 00:00:00" data-date-timezone="+0"></div>
                <!--<div class="elem-center">
      <div class="digit">
       <span class="days">00</span>
       <span class="txt">days</span>
      </div>
     </div>-->
                <!-- Logo instead -->

                <div class="logo">
                    <a href="#">
                        <img src="{{ asset('assets/global/plugins/admin/img/logo-avi.png') }}">
                    </a>
                </div>

                <!--
     <div class="elem-bottom">
      <div class="deco"></div>-->

                <!--						<span class="days">00</span><span class="thin">D</span>-->
                <!--	<span class="hours">00</span><span class="thin">H</span>
      <span class="minutes">00</span><span class="thin">MN</span>
      <span class="seconds">00</span><span class="thin">S</span>
     </div>-->

            </div>


            <footer>
                <!--<p>Before we launch our <strong>new website</strong></p>-->
            </footer>
        </div>
    </div>
    <!-- End of timer pane -->

    <!-- BEGIN OF site main content content here -->
    <main class="page-main" id="mainpage">

        <!-- Begin of home page -->
        <div class="section page-register page page-cent" id="s-home">
            <section class="content">
                <header class="p-title">
                    <h3>Local Wizard <i class="ion ion-compose"></i></h3>
                    <h4 class="subhead">Create New Local Wizard Pro in Avi the Jeweler</h4>
                </header>
                <div>
                    <div id="mail-subscription" class="form magic send_email_form" method="get" action="#">
                        <p class="invite">Click on button to create our New Font Wizard</p>


                        <a href="/create" target="_blank">
                            <button id="createw" class="button email_b" name="submit_email">Create New Local
                                Wizard</button>
                        </a>


                        <p class="email-ok invisible"><strong>Thank you</strong> for your subscription. We will inform
                            you.</p>

                    </div>
            </section>
            <footer class="p-footer p-scrolldown">

            </footer>
        </div>
        <!-- End of register page -->



        <!-- Begin of register page -->
        <div class="section page-register page page-cent" id="s-register">
            <section class="content">
                <header class="p-title">
                    <h3>Share Wizard <i class="ion ion-compose"></i></h3>
                    <h4 class="subhead">Share our Wizard Pro Link by SMS</h4>
                </header>
                <div>
                    <div id="phone-link" class="form magic">
                        <p class="invite">Please, write the phone and send our link for external access :</p>
                        <div class="fields clearfix">
                            <div class="input">
                                <label for="phoneval">Phone </label>
                                <input id="phoneval" class="email_f" name="email" type="text" required
                                    placeholder="(555) 555-5555" data-validation-type="phone">
                            </div>
                            <div class="buttons">
                                <button id="submit-phone" class="button email_b" name="submit_phone">Send</button>
                            </div>

                        </div>
                        <br>
                        <div>

                            <label for="myBtn" style="margin-right: 12px">Share a Link </label>
                            <button id="myBtn" class="button email_b" name="submit_email">Create Link</button>

                        </div>

                        <p class="email-ok invisible"><strong>Thank you</strong> for your subscription. We will inform
                            you.</p>
                    </div>
                </div>
            </section>
            <div id="myModal" class="modal">

                <!-- Modal content -->
                <div class="modal-content magic box_modal">
                    <span class="close" style="cursor: pointer;">&times;</span>

                    <br>
                    <h3 style="color: black">Link Generated</h3>
                    <input type="text" value="Hello World" id="myInput" readonly>
                    <button onclick="myFunction()" class="btn_copy">Copy link</button>
                    <br>
                    <p style="font-style: italic; color:dimgray">Remember that each shared link can expire in 30 min.
                        If the link is expired you must recreate and send it again </p>
                </div>


            </div>
            <footer class="p-footer p-scrolldown">

            </footer>
        </div>
        <!-- End of register page -->

        <!-- Begin of about us page -->
        <div class="section page-about page page-cent" id="s-about-us">
            <section class="content">
                <header class="p-title">
                    <h3>About Us<i class="ion ion-android-information">
                        </i>
                    </h3>
                    <h4 class="subhead">We The New Luxury of Shopping Fine Jewelry.
                    </h4>
                    <!--<h4 class="subhead">We <span class="bold">make</span> only <span class="bold">beautiful</span> things</h4>-->
                </header>
                <article class="text">
                    <p> Avi the Jeweler is a top custom, high-rated diamond jewelry store, located at 3161 W Oakland
                        Park, FL 33311</p>
                    <p> We have extensive expertise in the jewelry business for over 20 years. We’re able to provide you
                        with the best custom designs at the best prices with our own in-house manufacturer. </p>
                    <p> We sell all types of jewelry on our online store from hip-hop jewelry, custom design chains to
                        fine, high-end jewelry, such as diamond tennis bracelets, necklaces and earrings. </p>
                    <p>Our online store makes shopping with Avi the Jeweler very easy and convenient by an easy-to-use
                        layout,
                        allowing you to add items in your cart to purchase items. We do have finance options for those
                        who are looking to utilize these services.</p>
                </article>
            </section>
            <footer class="p-footer p-scrolldown">

            </footer>
        </div>
        <!-- End of about us page -->

        <!-- Begin of Contact page   -->
        <div class="section page-contact page page-cent  bg-color" data-bgcolor="rgba(95, 25, 208, 0.88)s"
            id="s-contact">
            <!-- Begin of contact information -->
            <div class="slide" id="s-information" data-anchor="information">
                <section class="content">
                    <header class="p-title">
                        <h3>Contact<i class="ion ion-location">
                            </i>
                        </h3>
                        <ul class="buttons">
                            <li class="show-for-medium-up">
                                <a title="About" href="#about-us"><i class="ion ion-android-information"></i></a>
                            </li>
                            <!--<li>
         <a title="Contact" href="#contact/information"><i class="ion ion-location"></i></a>
        </li>-->
                            <li>
                                <a title="Message" href="#contact/message"><i class="ion ion-email"></i></a>
                            </li>
                        </ul>
                    </header>
                    <!-- Begin Of Page SubSction -->
                    <div class="contact">
                        <div class="row">
                            <div class="medium-6 columns left">
                                <ul>
                                    <li>
                                        <h4>Email</h4>
                                        <p><a href="mailto:info@avijewels.com">info@avijewels.com</a></p>
                                    </li>
                                    <li>
                                        <h4>Address</h4>
                                        <p>3161 W Oakland Park
                                            <br>MIAMI, FL 33311
                                        </p>
                                    </li>
                                    <li>
                                        <h4>Phone</h4>
                                        <p>(954) 306-8025</p>
                                    </li>
                                </ul>
                            </div>
                            <div class="medium-6 columns social-links right">
                                <ul>

                                    <!-- legal notice -->
                                    <li class="show-for-medium-up">
                                        <h4>Website</h4>
                                        <p><a href="http://www.avijewels.com">www.avijewels.com</a></p>
                                    </li>
                                    <li class="show-for-medium-up">
                                        <h4>Find us on</h4>
                                        <!-- Begin of Social links -->
                                        <div class="socialnet">
                                            <a href="https://www.facebook.com/AviTheJeweler"><i
                                                    class="ion ion-social-facebook"></i></a>
                                            <a href="https://www.instagram.com/avi_thejeweler/"><i
                                                    class="ion ion-social-instagram"></i></a>
                                            <!--	<a href="#"><i class="ion ion-social-twitter"></i></a>
            <a href="#"><i class="ion ion-social-pinterest"></i></a>
            <a href="#"><i class="ion ion-social-tumblr"></i></a>-->
                                        </div>
                                        <!-- End of Social links -->
                                    </li>
                                    <li>
                                        <p><img src="{{ asset('assets/global/plugins/admin/img/logo-avi.png') }}"
                                                alt="Logo" class="logo"></p>
                                        <!--<p class="small">Bientot by <strong><a href="http://highhay.com">Brand</a></strong>. All right reserved 2022</p>-->
                                    </li>
                                </ul>

                            </div>
                        </div>
                    </div>
                    <!-- End of page SubSection -->
                </section>
            </div>
            <!-- end of contact information -->

            <!-- begin of contact message -->
            <div class="slide" id="s-message" data-anchor="message">
                <section class="content">
                    <header class="p-title">
                        <h3>Write to us<i class="ion ion-email">
                            </i>
                        </h3>
                        <ul class="buttons">
                            <li class="show-for-medium-up">
                                <a title="About" href="#about-us"><i class="ion ion-android-information"></i></a>
                            </li>
                            <li>
                                <a title="Contact" href="#contact/information"><i class="ion ion-location"></i></a>
                            </li>
                            <!--<li>
         <a title="Message" href="#contact/message"><i class="ion ion-email"></i></a>
        </li>-->
                        </ul>
                    </header>
                    <!-- Begin Of Page SubSction -->

                    <div class="page-block c-right v-zoomIn">
                        <div class="wrapper">
                            <div>
                                <form class="message form send_message_form" method="get"
                                    action="ajaxserver/serverfile.php">
                                    <div class="fields clearfix">
                                        <div class="input">
                                            <label for="mes-name">Name </label>
                                            <input id="mes-name" name="name" type="text"
                                                placeholder="Your Name" required>
                                        </div>
                                        <div class="buttons">
                                            <button id="submit-message" class="button email_b"
                                                name="submit_message">Ok</button>
                                        </div>
                                    </div>
                                    <div class="fields clearfix">
                                        <div class="input">
                                            <label for="mes-email">Email </label>
                                            <input id="mes-email" type="email" placeholder="Email Address"
                                                name="email" required>
                                        </div>
                                    </div>
                                    <div class="fields clearfix no-border">
                                        <label for="mes-text">Message </label>
                                        <textarea id="mes-text" placeholder="Message ..." name="message" required></textarea>

                                        <div>
                                            <p class="message-ok invisible">Your message has been sent, thank you.</p>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                    <!-- End Of Page SubSction -->
                </section>

            </div>
            <!-- End of contact message -->
        </div>
        <!-- End of Contact page  -->

    </main>

    <!-- END OF site main content content here -->

    <!-- Begin of site footer -->
    <footer class="page-footer">
        <div>
            <a href="https://www.facebook.com/AviTheJewelry" target="_blank"><i
                    class="ion icon ion-social-facebook"></i></a>
            <a href="https://www.instagram.com/AviTheJewelry/" target="_blank"><i
                    class="ion icon ion-social-instagram"></i></a>

        </div>
    </footer>
    <!-- End of site footer -->


    <!--        <script src="//ajax.googleapis.com/ajax/libs/jquery/1.11.0/jquery.min.js"></script>-->

    <!-- All Javascript plugins goes here -->
    <!--		<script src="//code.jquery.com/jquery-1.11.2.min.js"></script>-->
    <script src="{{ asset('assets/global/plugins/admin/js/vendor/jquery-1.11.2.min.js') }}"></script>
    <!-- All vendor scripts -->
    <script src="{{ asset('assets/global/plugins/admin/js/vendor/all.js') }}"></script>

    <!-- Detailed vendor scripts -->
    <!--<script src="./js/vendor/jquery.fullPage.min.js"></script>
        <script src="./js/vendor/jquery.slimscroll.min.js"></script>
        <script src="./js/vendor/jquery.knob.min.js"></script>
        <script src="./js/vegas/vegas.min.js"></script>
        <script src="./js/jquery.maximage.js"></script>
        <script src="./js/okvideo.min.js"></script>-->

    <!-- Downcount JS -->
    <script src="{{ asset('assets/global/plugins/admin/js/jquery.downCount.js') }}"></script>

    <!-- Form s cript -->
    <script src="{{ asset('assets/global/plugins/admin/js/form_script.js') }}"></script>

    <!-- Javascript main files -->
    <script src="{{ asset('assets/global/plugins/admin/js/main.js') }}"></script>


</body>
<script type="text/javascript">
    document.getElementById('phoneval').addEventListener('input', function(e) {
        var x = e.target.value.replace(/\D/g, '').match(/(\d{0,3})(\d{0,3})(\d{0,4})/);
        e.target.value = !x[2] ? x[1] : '(' + x[1] + ') ' + x[2] + (x[3] ? '-' + x[3] : '');
    });



    $("#submit-phone").click(function(e) {

        e.preventDefault();
        /* var nombre = $('#name').val();
         var nombre = $('#display_name').val();*/
        var token = '{{ csrf_token() }}'; // ó $("#token").val() si lo tienes en una etiqueta html.
        var phone = $('#phoneval').val()
        var data = {
            sms: true,
            phone: phone,
            _token: token
        };
        $.ajax({
            type: "post",
            url: "{{ url('web/function/sendLink') }}",
            data: data,
            success: function(msg) {
                $('#phoneval').val("");
                alert("Message successfully send");
            },
            error: function(result) {
                alert("Error in SMS servicies");
            }
        });
    });
</script>
<script>
    var modal = document.getElementById("myModal");

    // Get the button that opens the modal
    var btn = document.getElementById("myBtn");

    // Get the <span> element that closes the modal
    var span = document.getElementsByClassName("close")[0];

    // When the user clicks on the button, open the modal
    btn.onclick = function() {

        /* var nombre = $('#name').val();
         var nombre = $('#display_name').val();*/
        var token = '{{ csrf_token() }}'; // ó $("#token").val() si lo tienes en una etiqueta html.
        var phone = $('#phoneval').val()
        var data = {
            sms: false,
            _token: token
        };
        $.ajax({
            type: "post",
            url: "{{ url('web/function/sendLink') }}",
            data: data,
            success: function(datos) {
                console.log(datos);
                datos = datos.replace(/^"/, "");
                datos = datos.replace(/"$/, "");
                $('#myInput').val(datos);
                modal.style.display = "block";
            },
            error: function(result) {
                alert("Error in SMS servicies");
            }
        });

    }

    // When the user clicks on <span> (x), close the modal
    span.onclick = function() {
        modal.style.display = "none";
    }

    // When the user clicks anywhere outside of the modal, close it
    window.onclick = function(event) {
        if (event.target == modal) {
            modal.style.display = "none";
        }
    }

    function myFunction() {
        /* Get the text field */
        var copyText = document.getElementById("myInput");

        /* Select the text field */
        copyText.select();
        copyText.setSelectionRange(0, 99999); /* For mobile devices */

        /* Copy the text inside the text field */
        try {
            var retVal = document.execCommand("copy");
            console.log('Copy to clipboard returns: ' + retVal);
            alert("Copied the text: " + copyText.value);
        } catch (err) {
            console.log('Error while copying to clipboard: ' + err);
        }
    }
</script>

</html>
