@extends('layouts.login-1')

@section('content')
    <!-- BEGIN : LOGIN PAGE 5-1 -->
    <div class="user-login-5">
        <div class="row bs-reset">
            <div class="col-md-6 login-container bs-reset mt-login-5-bsfix">
                <div class="login-content text-center">
                    <div style="margin-bottom: 20px">
                        <img src="{{ asset('./img/logo-avi.png') }}" width="100px" />
                        <h1>Ctrl</h1>
                    </div>

                    @if (session('status'))
                        <div class="alert alert-success" style="margin-top: 20px;">
                            {{ session('status') }}
                        </div>
                    @endif
                    <form class="forget-form text-left" action="{{ route('password.email') }}" method="post">
                        {{ csrf_field() }}
                        <h3 class="font-green">Forgot Password ?</h3>
                        <p> Enter your e-mail address below to reset your password. </p>
                        <div class="form-group">
                            <input
                                class="form-control placeholder-no-fix form-group {{ $errors->has('email') ? ' has-error' : '' }}"
                                type="text" autocomplete="off" placeholder="Email" name="email"
                                value="{{ old('email') }}" />
                            @if ($errors->has('email'))
                                <span class="help-block">
                                    <strong>{{ $errors->first('email') }}</strong>
                                </span>
                            @endif
                        </div>
                        <div class="form-actions">
                            <a href="<?php echo url('/'); ?>" class="btn green btn-outline">Back</a>
                            <button type="submit" class="btn btn-success uppercase pull-right">Send Password Reset
                                Link</button>
                        </div>
                    </form>
                </div>
                <div class="login-footer">
                    <div class="row bs-reset">
                        <div class="col-xs-5 bs-reset"></div>
                        <div class="col-xs-7 bs-reset">
                            <div class="login-copyright text-right">
                                <p>Copyright &copy; avijewels.com</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-6 bs-reset mt-login-5-bsfix">
                <div class="login-bg" style="background-image:url(../assets/pages/img/login/bg1.jpg)">
                </div>
            </div>
        </div>
    </div>
    <!-- END : LOGIN PAGE 5-1 -->
@endsection
