@extends('layouts.login')

@section('content')
    <!-- BEGIN : LOGIN PAGE 5-1 -->
    <div class="user-login-5">
        <div class="row bs-reset">
            <div class="col-md-6 login-container bs-reset mt-login-5-bsfix">
                <div class="login-content text-center">
                    <img src="{{ asset('./img/logo-avi.png') }}" width="100px" />
                    <h1>Ctrl Login</h1>
                    <p class="text-left">Lorem ipsum dolor sit amet, coectetuer adipiscing elit sed diam nonummy et nibh
                        euismod aliquam erat volutpat.</p>
                    <form class="login-form" method="post" action="{{ route('login') }}">
                        {{ csrf_field() }}
                        <div class="alert alert-danger display-hide">
                            <button class="close" data-close="alert"></button>
                            <span>Enter any username and password. </span>
                        </div>

                        <div class="row">
                            <div class="col-xs-6">
                                <input
                                    class="form-control form-control-solid placeholder-no-fix form-group {{ $errors->has('email') ? ' has-error' : '' }}"
                                    type="text" autocomplete="off" placeholder="Email" name="email" required
                                    value="{{ old('email') }}" />
                                @if ($errors->has('email'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('email') }}</strong>
                                    </span>
                                @endif
                            </div>
                            <div class="col-xs-6">
                                <input
                                    class="form-control form-control-solid placeholder-no-fix form-group {{ $errors->has('password') ? ' has-error' : '' }}"
                                    type="password" autocomplete="off" placeholder="Password" name="password" required />
                                @if ($errors->has('password'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('password') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-sm-4">
                                <div class="rem-password">
                                    <label class="rememberme mt-checkbox mt-checkbox-outline">
                                        <input type="checkbox" name="remember" {{ old('remember') ? 'checked' : '' }}>
                                        Remember me
                                        <span></span>
                                    </label>
                                </div>
                            </div>
                            <div class="col-sm-8 text-right">
                                <div class="forgot-password">
                                    <a href="{{ route('password.request') }}" id="" class="forget-password">Forgot
                                        Password?</a>
                                </div>
                                <button class="btn green" type="submit">Sign In</button>
                            </div>
                        </div>
                    </form>
                </div>
                <div class="login-footer">
                    <div class="row bs-reset">
                        <div class="col-xs-5 bs-reset"></div>
                        <div class="col-xs-7 bs-reset">
                            <div class="login-copyright text-right">
                                <p>Copyright &copy; avijewelels.com</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-6 bs-reset mt-login-5-bsfix">
                <div class="login-bg" style="background-image:url(../assets/pages/img/login/bg1.jpg)">

                </div>
            </div>
        </div>
    </div>
    <!-- END : LOGIN PAGE 5-1 -->
@endsection
