@extends('layouts.adminfonts')

@section('title', 'Font Details')
@section('page-title', 'Font Details')

@section('content')
    <!-- Font Information Card -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h5 class="card-title mb-0">
                        <i class="fas fa-font me-2"></i>
                        {{ $font->display_name }}
                    </h5>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <h6>Font Information</h6>
                            <table class="table table-sm">
                                <tr>
                                    <td><strong>CSS Name:</strong></td>
                                    <td><code>{{ $font->font_name }}</code></td>
                                </tr>
                                <tr>
                                    <td><strong>Display Name:</strong></td>
                                    <td>{{ $font->display_name }}</td>
                                </tr>
                                <tr>
                                    <td><strong>File Name:</strong></td>
                                    <td>{{ $font->file_name }}</td>
                                </tr>
                                <tr>
                                    <td><strong>File Path:</strong></td>
                                    <td>{{ $font->file_path }}</td>
                                </tr>
                                <tr>
                                    <td><strong>Gender:</strong></td>
                                    <td>
                                        <span class="badge bg-info">{{ $font->gender }}</span>
                                    </td>
                                </tr>
                                <tr>
                                    <td><strong>Font Size:</strong></td>
                                    <td>{{ $font->font_size }}vw</td>
                                </tr>
                                <tr>
                                    <td><strong>Top Position:</strong></td>
                                    <td>{{ $font->top_position }}px</td>
                                </tr>
                                <tr>
                                    <td><strong>Rating:</strong></td>
                                    <td>
                                        <div class="d-flex align-items-center">
                                            @for ($i = 1; $i <= 5; $i++)
                                                <i
                                                    class="fas fa-star {{ $i <= $font->review_rating ? 'text-warning' : 'text-muted' }}"></i>
                                            @endfor
                                            <span class="ms-2">({{ $font->review_rating }}/5)</span>
                                        </div>
                                    </td>
                                </tr>
                                <tr>
                                    <td><strong>Uppercase Only:</strong></td>
                                    <td>
                                        @if ($font->uppercase_only)
                                            <span class="badge bg-success">
                                                <i class="fas fa-check me-1"></i>
                                                Yes
                                            </span>
                                        @else
                                            <span class="badge bg-secondary">
                                                <i class="fas fa-times me-1"></i>
                                                No
                                            </span>
                                        @endif
                                    </td>
                                </tr>
                                <tr>
                                    <td><strong>Tags:</strong></td>
                                    <td>
                                        @if ($font->tags && count($font->tags) > 0)
                                            <div class="d-flex flex-wrap gap-1">
                                                @foreach ($font->tags as $tag)
                                                    <span class="badge bg-primary">{{ $tag }}</span>
                                                @endforeach
                                            </div>
                                        @else
                                            <span class="text-muted">No tags assigned</span>
                                        @endif
                                    </td>
                                </tr>
                                <tr>
                                    <td><strong>Status:</strong></td>
                                    <td>
                                        <span
                                            class="status-badge {{ $font->is_active ? 'status-active' : 'status-inactive' }}">
                                            {{ $font->is_active ? 'Active' : 'Inactive' }}
                                        </span>
                                    </td>
                                </tr>
                                <tr>
                                    <td><strong>Created:</strong></td>
                                    <td>{{ $font->created_at->format('M d, Y H:i') }}</td>
                                </tr>
                                <tr>
                                    <td><strong>Updated:</strong></td>
                                    <td>{{ $font->updated_at->format('M d, Y H:i') }}</td>
                                </tr>
                            </table>
                        </div>

                        <div class="col-md-6">
                            <h6>CSS Style</h6>
                            <div class="bg-light p-3 rounded">
                                <code style="font-size: 12px; word-break: break-all;">{{ $font->style }}</code>
                            </div>

                            <h6 class="mt-4">Font URL</h6>
                            <div class="bg-light p-3 rounded">
                                <code style="font-size: 12px; word-break: break-all;">{{ $font->font_url }}</code>
                            </div>
                        </div>
                    </div>

                    <div class="mt-4">
                        <h6>Actions</h6>
                        <div class="btn-group" role="group">
                            <a href="{{ route('admin.fonts.edit', $font) }}" class="btn btn-warning">
                                <i class="fas fa-edit me-2"></i>
                                Edit Font
                            </a>

                            <form action="{{ route('admin.fonts.toggle', $font) }}" method="POST" class="d-inline">
                                @csrf
                                <button type="submit" class="btn {{ $font->is_active ? 'btn-danger' : 'btn-success' }}">
                                    <i class="fas {{ $font->is_active ? 'fa-pause' : 'fa-play' }} me-2"></i>
                                    {{ $font->is_active ? 'Deactivate' : 'Activate' }}
                                </button>
                            </form>

                            <form action="{{ route('admin.fonts.destroy', $font) }}" method="POST" class="d-inline"
                                onsubmit="return confirm('Are you sure you want to delete this font? This action cannot be undone.')">
                                @csrf
                                @method('DELETE')
                                <button type="submit" class="btn btn-danger">
                                    <i class="fas fa-trash me-2"></i>
                                    Delete Font
                                </button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Full Width Font Preview -->
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h5 class="card-title mb-0">
                        <i class="fas fa-eye me-2"></i>
                        Font Preview
                    </h5>
                </div>
                <div class="card-body">
                    <!-- Preview Controls -->
                    <div class="row mb-4">
                        <div class="col-md-4">
                            <div class="mb-3">
                                <label for="preview-text" class="form-label">
                                    <i class="fas fa-font me-2"></i>
                                    Preview Text
                                </label>
                                <input type="text" id="preview-text" class="form-control" value="Example"
                                    placeholder="Enter preview text">
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="mb-3">
                                <label for="preview-size" class="form-label">
                                    <i class="fas fa-text-height me-2"></i>
                                    Preview Size
                                </label>
                                <div class="d-flex align-items-center">
                                    <input type="range" id="preview-size" class="form-range me-3" min="8"
                                        max="50" value="{{ $font->font_size }}">
                                    <span class="badge bg-primary" id="size-value">{{ $font->font_size }}vw</span>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="mb-3">
                                <label for="preview-color" class="form-label">
                                    <i class="fas fa-palette me-2"></i>
                                    Preview Color
                                </label>
                                <div class="d-flex align-items-center">
                                    <input type="color" id="preview-color" class="form-control form-control-color me-3"
                                        value="#667eea">
                                    <span class="badge bg-secondary" id="color-value">#667eea</span>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Full Width Preview -->
                    <div class="preview-container-fullscreen">
                        <div class="font-preview-fullscreen" id="font-preview-show" style="{{ $font->style }}">
                            Example
                        </div>
                    </div>

                    <!-- Download Button -->
                    <div class="text-center mt-3">
                        <button type="button" class="btn btn-outline-primary" onclick="downloadFont()">
                            <i class="fas fa-download me-2"></i>
                            Download Font File
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Usage Example Card -->
    <div class="row mt-4">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h5 class="card-title mb-0">
                        <i class="fas fa-code me-2"></i>
                        Usage Example
                    </h5>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <h6>CSS:</h6>
                            <div class="bg-dark text-light p-3 rounded">
                                <code style="font-size: 12px;">
                                    .my-text {<br>
                                    &nbsp;&nbsp;{{ $font->style }}<br>
                                    }
                                </code>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <h6>HTML:</h6>
                            <div class="bg-dark text-light p-3 rounded">
                                <code style="font-size: 12px;">
                                    &lt;div class="my-text"&gt;Your Text Here&lt;/div&gt;
                                </code>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="mt-4">
        <a href="{{ route('admin.fonts.index') }}" class="btn btn-secondary">
            <i class="fas fa-arrow-left me-2"></i>
            Back to Font List
        </a>
    </div>
@endsection

@section('scripts')
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const previewElement = document.getElementById('font-preview-show');
            const previewTextInput = document.getElementById('preview-text');
            const previewSizeInput = document.getElementById('preview-size');
            const previewColorInput = document.getElementById('preview-color');
            const sizeValueElement = document.getElementById('size-value');
            const colorValueElement = document.getElementById('color-value');

            // Update preview text
            previewTextInput.addEventListener('input', function() {
                previewElement.textContent = this.value || 'Example';
            });

            // Update preview size
            previewSizeInput.addEventListener('input', function() {
                const size = this.value;
                sizeValueElement.textContent = size + 'vw';

                // Update the style
                const currentStyle = previewElement.getAttribute('style');
                const newStyle = currentStyle.replace(/font-size:\s*\d+vw/, `font-size: ${size}vw`);
                previewElement.setAttribute('style', newStyle);
            });

            // Update preview color
            previewColorInput.addEventListener('change', function() {
                const color = this.value;
                colorValueElement.textContent = color;

                // Update the style
                const currentStyle = previewElement.getAttribute('style');
                const newStyle = currentStyle.replace(/color:\s*[^;]+/, `color: ${color}`);
                previewElement.setAttribute('style', newStyle);
            });
        });

        function downloadFont() {
            const fontUrl = '{{ $font->font_url }}';
            const link = document.createElement('a');
            link.href = fontUrl;
            link.download = '{{ $font->file_path }}';
            document.body.appendChild(link);
            link.click();
            document.body.removeChild(link);
        }
    </script>
@endsection
