@extends('layouts.adminfonts')

@section('title', 'Edit Font')
@section('page-title', 'Edit Font: ' . $font->display_name)

@section('content')
    <div class="row">
        <div class="col-md-8">
            <div class="card">
                <div class="card-header">
                    <h5 class="card-title mb-0">
                        <i class="fas fa-edit me-2"></i>
                        Edit Font Information
                    </h5>
                </div>
                <div class="card-body">
                    <form action="{{ route('admin.fonts.update', $font) }}" method="POST">
                        @csrf
                        @method('PUT')

                        <div class="row">
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="display_name" class="form-label">Display Name *</label>
                                    <input type="text" class="form-control @error('display_name') is-invalid @enderror"
                                        id="display_name" name="display_name"
                                        value="{{ old('display_name', $font->display_name) }}"
                                        placeholder="e.g., Beautiful Script" required>
                                    @error('display_name')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="file_name" class="form-label">File Name *</label>
                                    <input type="text" class="form-control @error('file_name') is-invalid @enderror"
                                        id="file_name" name="file_name" value="{{ old('file_name', $font->file_name) }}"
                                        placeholder="e.g., BeautifulScript-Regular" required>
                                    @error('file_name')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="mb-3">
                            <label for="font_file" class="form-label">Font File (Optional)</label>
                            <input type="file" class="form-control @error('font_file') is-invalid @enderror"
                                id="font_file" name="font_file" accept=".ttf,.otf,.woff,.woff2">
                            <div class="form-text">
                                Leave empty to keep current file. Supported formats: TTF, OTF, WOFF, WOFF2 (Max size: 10MB)
                            </div>
                            @error('font_file')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="row">
                            <div class="col-md-4">
                                <div class="mb-3">
                                    <label for="gender" class="form-label">Gender *</label>
                                    <select class="form-select @error('gender') is-invalid @enderror" id="gender"
                                        name="gender" required>
                                        <option value="">Select Gender</option>
                                        <option value="Male"
                                            {{ old('gender', $font->gender) == 'Male' ? 'selected' : '' }}>Male</option>
                                        <option value="Female"
                                            {{ old('gender', $font->gender) == 'Female' ? 'selected' : '' }}>Female</option>
                                        <option value="Unisex"
                                            {{ old('gender', $font->gender) == 'Unisex' ? 'selected' : '' }}>Unisex</option>
                                    </select>
                                    @error('gender')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="mb-3">
                                    <label for="font_size" class="form-label">Font Size (vw) *</label>
                                    <input type="number" class="form-control @error('font_size') is-invalid @enderror"
                                        id="font_size" name="font_size" value="{{ old('font_size', $font->font_size) }}"
                                        min="8" max="50" required>
                                    @error('font_size')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="mb-3">
                                    <label for="top_position" class="form-label">Top Position (px) *</label>
                                    <input type="number" class="form-control @error('top_position') is-invalid @enderror"
                                        id="top_position" name="top_position"
                                        value="{{ old('top_position', $font->top_position) }}" min="0"
                                        max="200" required>
                                    @error('top_position')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="review_rating" class="form-label">Rating *</label>
                                    <div class="rating-input">
                                        @for ($i = 1; $i <= 5; $i++)
                                            <input type="radio" id="rating{{ $i }}" name="review_rating"
                                                value="{{ $i }}"
                                                {{ old('review_rating', $font->review_rating) == $i ? 'checked' : '' }}
                                                required>
                                            <label for="rating{{ $i }}" class="rating-star">
                                                <i class="fas fa-star"></i>
                                            </label>
                                        @endfor
                                    </div>
                                    @error('review_rating')
                                        <div class="text-danger small">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="mb-3">
                                    <div class="form-check form-switch">
                                        <input class="form-check-input" type="checkbox" id="uppercase_only"
                                            name="uppercase_only" value="1"
                                            {{ old('uppercase_only', $font->uppercase_only) ? 'checked' : '' }}>
                                        <label class="form-check-label" for="uppercase_only">
                                            <i class="fas fa-text-height me-1"></i>
                                            Uppercase Only
                                        </label>
                                    </div>
                                    <small class="text-muted">Check if this font should only be used in uppercase</small>
                                    @error('uppercase_only')
                                        <div class="text-danger small">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="mb-3">
                            <label for="tags" class="form-label">Tags</label>
                            <input type="text" class="form-control @error('tags') is-invalid @enderror" id="tags"
                                name="tags"
                                value="{{ old('tags', is_array($font->tags) ? implode(', ', $font->tags) : '') }}"
                                placeholder="e.g., script, bold, vintage, modern (separate with commas)">
                            <div class="form-text">
                                Add tags to help categorize and search for this font. Separate multiple tags with commas.
                            </div>
                            @error('tags')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="mb-3">
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" id="is_active" name="is_active"
                                    value="1" {{ old('is_active', $font->is_active) ? 'checked' : '' }}>
                                <label class="form-check-label" for="is_active">
                                    Active Font
                                </label>
                            </div>
                            <div class="form-text">
                                Uncheck to temporarily disable this font from appearing in the font selection.
                            </div>
                        </div>

                        <div class="d-flex justify-content-between">
                            <a href="{{ route('admin.fonts.show', $font) }}" class="btn btn-secondary">
                                <i class="fas fa-arrow-left me-2"></i>
                                Back to Details
                            </a>
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-save me-2"></i>
                                Update Font
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>

        <div class="col-md-4">
            <div class="card">
                <div class="card-header">
                    <h5 class="card-title mb-0">
                        <i class="fas fa-info-circle me-2"></i>
                        Current Font Info
                    </h5>
                </div>
                <div class="card-body">
                    <table class="table table-sm">
                        <tr>
                            <td><strong>CSS Name:</strong></td>
                            <td><code>{{ $font->font_name }}</code></td>
                        </tr>
                        <tr>
                            <td><strong>File Path:</strong></td>
                            <td>{{ $font->file_path }}</td>
                        </tr>
                        <tr>
                            <td><strong>Created:</strong></td>
                            <td>{{ $font->created_at->format('M d, Y') }}</td>
                        </tr>
                        <tr>
                            <td><strong>Last Updated:</strong></td>
                            <td>{{ $font->updated_at->format('M d, Y') }}</td>
                        </tr>
                    </table>

                    <div class="alert alert-info">
                        <i class="fas fa-lightbulb me-2"></i>
                        <strong>Note:</strong> The CSS name and file path cannot be changed after creation.
                        If you need to change the font file, delete this font and upload a new one.
                    </div>
                </div>
            </div>

            <div class="card mt-3">
                <div class="card-header">
                    <h5 class="card-title mb-0">
                        <i class="fas fa-eye me-2"></i>
                        Live Preview
                    </h5>
                </div>
                <div class="card-body">
                    <div id="live-preview" class="text-center p-3 border rounded">
                        <div class="font-preview" style="{{ $font->style }}">
                            {{ $font->display_name }}
                        </div>
                    </div>
                    <small class="text-muted">Preview updates as you make changes</small>
                </div>
            </div>

            <div class="card mt-3">
                <div class="card-header">
                    <h5 class="card-title mb-0">
                        <i class="fas fa-exclamation-triangle me-2"></i>
                        Danger Zone
                    </h5>
                </div>
                <div class="card-body">
                    <p class="text-muted small mb-3">
                        Once you delete a font, there is no going back. Please be certain.
                    </p>
                    <form action="{{ route('admin.fonts.destroy', $font) }}" method="POST"
                        onsubmit="return confirm('Are you absolutely sure you want to delete this font? This action cannot be undone.')">
                        @csrf
                        @method('DELETE')
                        <button type="submit" class="btn btn-danger btn-sm w-100">
                            <i class="fas fa-trash me-2"></i>
                            Delete This Font
                        </button>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('scripts')
    <style>
        .rating-input {
            display: flex;
            gap: 5px;
        }

        .rating-input input[type="radio"] {
            display: none;
        }

        .rating-input label {
            cursor: pointer;
            font-size: 24px;
            color: #ddd;
            transition: color 0.2s ease;
        }

        .rating-input input[type="radio"]:checked~label,
        .rating-input label:hover {
            color: #ffc107;
        }

        .rating-input input[type="radio"]:checked~label~label {
            color: #ddd;
        }
    </style>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const displayNameInput = document.getElementById('display_name');
            const fontSizeInput = document.getElementById('font_size');
            const previewElement = document.getElementById('live-preview').querySelector('.font-preview');
            const fontName = '{{ $font->font_name }}';

            function updatePreview() {
                const displayName = displayNameInput.value || 'Example';
                const fontSize = fontSizeInput.value || 18;

                previewElement.textContent = displayName;
                previewElement.style.fontSize = fontSize + 'vw';
                previewElement.style.fontFamily = fontName;
            }

            displayNameInput.addEventListener('input', updatePreview);
            fontSizeInput.addEventListener('input', updatePreview);

            // Initial preview
            updatePreview();
        });
    </script>
@endsection
