@extends('layouts.adminfonts')

@section('title', 'Dashboard')
@section('page-title', 'Admin Dashboard')

@section('content')
    <div class="row">
        <div class="col-md-4">
            <div class="card">
                <div class="card-body text-center">
                    <i class="fas fa-font fa-3x text-primary mb-3"></i>
                    <h3>{{ \App\Models\Font::count() }}</h3>
                    <p class="text-muted">Total Fonts</p>
                </div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="card">
                <div class="card-body text-center">
                    <i class="fas fa-check-circle fa-3x text-success mb-3"></i>
                    <h3>{{ \App\Models\Font::where('is_active', true)->count() }}</h3>
                    <p class="text-muted">Active Fonts</p>
                </div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="card">
                <div class="card-body text-center">
                    <i class="fas fa-times-circle fa-3x text-danger mb-3"></i>
                    <h3>{{ \App\Models\Font::where('is_active', false)->count() }}</h3>
                    <p class="text-muted">Inactive Fonts</p>
                </div>
            </div>
        </div>
    </div>

    <div class="row mt-4">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h5 class="card-title mb-0">
                        <i class="fas fa-chart-bar me-2"></i>
                        Recent Fonts
                    </h5>
                </div>
                <div class="card-body">
                    @if (\App\Models\Font::count() > 0)
                        <div class="table-responsive">
                            <table class="table table-hover">
                                <thead>
                                    <tr>
                                        <th>Font Name</th>
                                        <th>Display Name</th>
                                        <th>Gender</th>
                                        <th>Status</th>
                                        <th>Created</th>
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach (\App\Models\Font::latest()->take(5)->get() as $font)
                                        <tr>
                                            <td>
                                                <span class="font-preview clickable-preview" style="{{ $font->style }}"
                                                    onclick="openFontPreview('{{ $font->style }}', '{{ $font->font_name }}', '{{ $font->display_name }}')"
                                                    title="Click to preview">
                                                    Example
                                                </span>
                                            </td>
                                            <td>{{ $font->display_name }}</td>
                                            <td>
                                                <span class="badge bg-info">{{ $font->gender }}</span>
                                            </td>
                                            <td>
                                                <span
                                                    class="status-badge {{ $font->is_active ? 'status-active' : 'status-inactive' }}">
                                                    {{ $font->is_active ? 'Active' : 'Inactive' }}
                                                </span>
                                            </td>
                                            <td>{{ $font->created_at->format('M d, Y') }}</td>
                                            <td>
                                                <a href="{{ route('admin.fonts.show', $font) }}"
                                                    class="btn btn-sm btn-outline-primary">
                                                    <i class="fas fa-eye"></i>
                                                </a>
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    @else
                        <div class="text-center py-4">
                            <i class="fas fa-font fa-3x text-muted mb-3"></i>
                            <h5 class="text-muted">No fonts uploaded yet</h5>
                            <p class="text-muted">Start by uploading your first font!</p>
                            <a href="{{ route('admin.fonts.create') }}" class="btn btn-primary">
                                <i class="fas fa-plus me-2"></i>
                                Upload Font
                            </a>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
@endsection
