<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Order;
use App\Models\Client;
use App\Models\OrderType;
use Carbon\Carbon;

class ReportOrdersSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Obtener clientes y tipos de órdenes existentes
        $clients = Client::all();
        $orderTypes = OrderType::all();

        if ($clients->isEmpty() || $orderTypes->isEmpty()) {
            $this->command->error('No hay clientes o tipos de órdenes disponibles. Ejecuta primero ClientSeeder y OrderTypeSeeder.');
            return;
        }

        // Datos de órdenes con costos para reportes
        $orders = [
            // Enero 2024
            [
                'norden' => 'REP-001',
                'order_date' => '2024-01-05',
                'description' => 'Desarrollo de aplicación web',
                'sale_price' => 2500.00,
                'cost_price' => 1200.00,
                'status' => 'Paid',
                'type_id' => $orderTypes->where('name', 'Development')->first()->id ?? $orderTypes->first()->id
            ],
            [
                'norden' => 'REP-002',
                'order_date' => '2024-01-12',
                'description' => 'Instalación de servidor',
                'sale_price' => 1800.00,
                'cost_price' => 800.00,
                'status' => 'Paid',
                'type_id' => $orderTypes->where('name', 'Installation')->first()->id ?? $orderTypes->first()->id
            ],
            [
                'norden' => 'REP-003',
                'order_date' => '2024-01-20',
                'description' => 'Consultoría de seguridad',
                'sale_price' => 1200.00,
                'cost_price' => 300.00,
                'status' => 'Paid',
                'type_id' => $orderTypes->where('name', 'Consulting')->first()->id ?? $orderTypes->first()->id
            ],

            // Febrero 2024
            [
                'norden' => 'REP-004',
                'order_date' => '2024-02-03',
                'description' => 'Mantenimiento de sistema',
                'sale_price' => 900.00,
                'cost_price' => 400.00,
                'status' => 'Paid',
                'type_id' => $orderTypes->where('name', 'Maintenance')->first()->id ?? $orderTypes->first()->id
            ],
            [
                'norden' => 'REP-005',
                'order_date' => '2024-02-15',
                'description' => 'Desarrollo de API',
                'sale_price' => 3200.00,
                'cost_price' => 1500.00,
                'status' => 'Paid',
                'type_id' => $orderTypes->where('name', 'Development')->first()->id ?? $orderTypes->first()->id
            ],
            [
                'norden' => 'REP-006',
                'order_date' => '2024-02-28',
                'description' => 'Instalación de red',
                'sale_price' => 2100.00,
                'cost_price' => 900.00,
                'status' => 'Paid',
                'type_id' => $orderTypes->where('name', 'Installation')->first()->id ?? $orderTypes->first()->id
            ],

            // Marzo 2024
            [
                'norden' => 'REP-007',
                'order_date' => '2024-03-08',
                'description' => 'Auditoría de seguridad',
                'sale_price' => 1800.00,
                'cost_price' => 500.00,
                'status' => 'Paid',
                'type_id' => $orderTypes->where('name', 'Consulting')->first()->id ?? $orderTypes->first()->id
            ],
            [
                'norden' => 'REP-008',
                'order_date' => '2024-03-15',
                'description' => 'Desarrollo de aplicación móvil',
                'sale_price' => 4500.00,
                'cost_price' => 2200.00,
                'status' => 'Paid',
                'type_id' => $orderTypes->where('name', 'Development')->first()->id ?? $orderTypes->first()->id
            ],
            [
                'norden' => 'REP-009',
                'order_date' => '2024-03-22',
                'description' => 'Mantenimiento preventivo',
                'sale_price' => 750.00,
                'cost_price' => 350.00,
                'status' => 'Paid',
                'type_id' => $orderTypes->where('name', 'Maintenance')->first()->id ?? $orderTypes->first()->id
            ],

            // Abril 2024
            [
                'norden' => 'REP-010',
                'order_date' => '2024-04-05',
                'description' => 'Instalación de base de datos',
                'sale_price' => 1600.00,
                'cost_price' => 700.00,
                'status' => 'Paid',
                'type_id' => $orderTypes->where('name', 'Installation')->first()->id ?? $orderTypes->first()->id
            ],
            [
                'norden' => 'REP-011',
                'order_date' => '2024-04-18',
                'description' => 'Desarrollo de dashboard',
                'sale_price' => 2800.00,
                'cost_price' => 1300.00,
                'status' => 'Paid',
                'type_id' => $orderTypes->where('name', 'Development')->first()->id ?? $orderTypes->first()->id
            ],
            [
                'norden' => 'REP-012',
                'order_date' => '2024-04-25',
                'description' => 'Consultoría de optimización',
                'sale_price' => 1500.00,
                'cost_price' => 400.00,
                'status' => 'Paid',
                'type_id' => $orderTypes->where('name', 'Consulting')->first()->id ?? $orderTypes->first()->id
            ],

            // Mayo 2024
            [
                'norden' => 'REP-013',
                'order_date' => '2024-05-02',
                'description' => 'Mantenimiento de servidores',
                'sale_price' => 1100.00,
                'cost_price' => 500.00,
                'status' => 'Paid',
                'type_id' => $orderTypes->where('name', 'Maintenance')->first()->id ?? $orderTypes->first()->id
            ],
            [
                'norden' => 'REP-014',
                'order_date' => '2024-05-10',
                'description' => 'Instalación de firewall',
                'sale_price' => 1900.00,
                'cost_price' => 800.00,
                'status' => 'Paid',
                'type_id' => $orderTypes->where('name', 'Installation')->first()->id ?? $orderTypes->first()->id
            ],
            [
                'norden' => 'REP-015',
                'order_date' => '2024-05-20',
                'description' => 'Desarrollo de sistema de facturación',
                'sale_price' => 3800.00,
                'cost_price' => 1800.00,
                'status' => 'Paid',
                'type_id' => $orderTypes->where('name', 'Development')->first()->id ?? $orderTypes->first()->id
            ],

            // Junio 2024
            [
                'norden' => 'REP-016',
                'order_date' => '2024-06-05',
                'description' => 'Consultoría de migración',
                'sale_price' => 2200.00,
                'cost_price' => 600.00,
                'status' => 'Paid',
                'type_id' => $orderTypes->where('name', 'Consulting')->first()->id ?? $orderTypes->first()->id
            ],
            [
                'norden' => 'REP-017',
                'order_date' => '2024-06-15',
                'description' => 'Mantenimiento de aplicaciones',
                'sale_price' => 850.00,
                'cost_price' => 400.00,
                'status' => 'Paid',
                'type_id' => $orderTypes->where('name', 'Maintenance')->first()->id ?? $orderTypes->first()->id
            ],
            [
                'norden' => 'REP-018',
                'order_date' => '2024-06-25',
                'description' => 'Instalación de sistema de backup',
                'sale_price' => 1400.00,
                'cost_price' => 600.00,
                'status' => 'Paid',
                'type_id' => $orderTypes->where('name', 'Installation')->first()->id ?? $orderTypes->first()->id
            ],

            // Julio 2024 (mes actual)
            [
                'norden' => 'REP-019',
                'order_date' => '2024-07-03',
                'description' => 'Desarrollo de aplicación de inventario',
                'sale_price' => 4200.00,
                'cost_price' => 2000.00,
                'status' => 'Paid',
                'type_id' => $orderTypes->where('name', 'Development')->first()->id ?? $orderTypes->first()->id
            ],
            [
                'norden' => 'REP-020',
                'order_date' => '2024-07-12',
                'description' => 'Consultoría de ciberseguridad',
                'sale_price' => 2800.00,
                'cost_price' => 700.00,
                'status' => 'Paid',
                'type_id' => $orderTypes->where('name', 'Consulting')->first()->id ?? $orderTypes->first()->id
            ],
            [
                'norden' => 'REP-021',
                'order_date' => '2024-07-20',
                'description' => 'Mantenimiento de red',
                'sale_price' => 950.00,
                'cost_price' => 450.00,
                'status' => 'Paid',
                'type_id' => $orderTypes->where('name', 'Maintenance')->first()->id ?? $orderTypes->first()->id
            ],
            [
                'norden' => 'REP-022',
                'order_date' => '2024-07-28',
                'description' => 'Instalación de sistema de monitoreo',
                'sale_price' => 1700.00,
                'cost_price' => 750.00,
                'status' => 'Paid',
                'type_id' => $orderTypes->where('name', 'Installation')->first()->id ?? $orderTypes->first()->id
            ],

            // Julio 2025 (futuro)
            [
                'norden' => 'REP-101',
                'order_date' => '2025-07-05',
                'description' => 'Desarrollo de sistema de reservas',
                'sale_price' => 5200.00,
                'cost_price' => 2500.00,
                'status' => 'Paid',
                'type_id' => $orderTypes->where('name', 'Development')->first()->id ?? $orderTypes->first()->id
            ],
            [
                'norden' => 'REP-102',
                'order_date' => '2025-07-12',
                'description' => 'Consultoría en cloud computing',
                'sale_price' => 3100.00,
                'cost_price' => 1200.00,
                'status' => 'Paid',
                'type_id' => $orderTypes->where('name', 'Consulting')->first()->id ?? $orderTypes->first()->id
            ],
            [
                'norden' => 'REP-103',
                'order_date' => '2025-07-18',
                'description' => 'Mantenimiento de infraestructura',
                'sale_price' => 1800.00,
                'cost_price' => 800.00,
                'status' => 'Paid',
                'type_id' => $orderTypes->where('name', 'Maintenance')->first()->id ?? $orderTypes->first()->id
            ],
            [
                'norden' => 'REP-104',
                'order_date' => '2025-07-25',
                'description' => 'Instalación de sistema de videovigilancia',
                'sale_price' => 2600.00,
                'cost_price' => 1100.00,
                'status' => 'Paid',
                'type_id' => $orderTypes->where('name', 'Installation')->first()->id ?? $orderTypes->first()->id
            ],
        ];

        $this->command->info('Creando órdenes para reportes...');

        foreach ($orders as $order) {
            Order::create([
                ...$order,
                'client_id' => $clients->random()->id,
            ]);
        }

        $this->command->info('Se crearon ' . count($orders) . ' órdenes para reportes exitosamente.');

        // Mostrar resumen de profit por tipo
        $this->command->info('Resumen de profit por tipo:');
        $profitByType = collect($orders)->groupBy('type_id')->map(function ($typeOrders) {
            return $typeOrders->sum(function ($order) {
                return $order['sale_price'] - $order['cost_price'];
            });
        });

        foreach ($profitByType as $typeId => $profit) {
            $typeName = $orderTypes->find($typeId)->name ?? 'Desconocido';
            $this->command->info("- {$typeName}: $" . number_format($profit, 2));
        }
    }
}
