<?php

namespace Database\Seeders;

use App\Models\Order;
use App\Models\Client;
use App\Models\OrderType;
use Illuminate\Database\Seeder;

class OrderSeeder extends Seeder
{
    public function run(): void
    {
        $clients = Client::all();
        $orderTypes = OrderType::all();

        $orders = [
            [
                'norden' => 'ORD-001',
                'order_date' => '2024-01-15',
                'description' => 'Computer equipment purchase',
                'status' => 'Completed',
                'type_id' => $orderTypes->where('name', 'Sale')->first()->id
            ],
            [
                'norden' => 'ORD-002',
                'order_date' => '2024-01-20',
                'description' => 'Server maintenance',
                'status' => 'Processing',
                'type_id' => $orderTypes->where('name', 'Maintenance')->first()->id
            ],
            [
                'norden' => 'ORD-003',
                'order_date' => '2024-02-01',
                'description' => 'Software installation',
                'status' => 'CAD Modeling',
                'type_id' => $orderTypes->where('name', 'Installation')->first()->id
            ],
            [
                'norden' => 'ORD-004',
                'order_date' => '2024-02-10',
                'description' => 'System updates',
                'status' => 'Processing',
                'type_id' => $orderTypes->where('name', 'Maintenance')->first()->id
            ],
            [
                'norden' => 'ORD-005',
                'order_date' => '2024-02-15',
                'description' => 'Data backup',
                'status' => 'Completed',
                'type_id' => $orderTypes->where('name', 'Maintenance')->first()->id
            ],
            [
                'norden' => 'ORD-006',
                'order_date' => '2024-03-01',
                'description' => 'Network configuration',
                'status' => 'CAD Modeling',
                'type_id' => $orderTypes->where('name', 'Installation')->first()->id
            ],
            [
                'norden' => 'ORD-007',
                'order_date' => '2024-03-05',
                'description' => 'Technical support',
                'status' => 'Processing',
                'type_id' => $orderTypes->where('name', 'Maintenance')->first()->id
            ],
            [
                'norden' => 'ORD-008',
                'order_date' => '2024-03-10',
                'description' => 'Web application development',
                'status' => 'CAD Modeling',
                'type_id' => $orderTypes->where('name', 'Development')->first()->id
            ],
            [
                'norden' => 'ORD-009',
                'order_date' => '2024-03-15',
                'description' => 'Database migration',
                'status' => 'Completed',
                'type_id' => $orderTypes->where('name', 'Development')->first()->id
            ],
            [
                'norden' => 'ORD-010',
                'order_date' => '2024-03-20',
                'description' => 'Security implementation',
                'status' => 'Processing',
                'type_id' => $orderTypes->where('name', 'Consulting')->first()->id
            ],
        ];

        foreach ($orders as $order) {
            Order::create([
                ...$order,
                'client_id' => $clients->random()->id,
            ]);
        }
    }
}
