<?php

namespace Database\Seeders;

use App\Models\Client;
use Illuminate\Database\Seeder;
use Faker\Factory as Faker;

class ClientSeeder extends Seeder
{
    public function run(): void
    {
        $faker = Faker::create('es_ES'); // Usar localización española

        // Array de ciudades mexicanas para mayor realismo
        $cities = [
            'Ciudad de México',
            'Guadalajara',
            'Monterrey',
            'Puebla',
            'Tijuana',
            'Ciudad Juárez',
            'León',
            'Zapopan',
            'Aguascalientes',
            'Mérida',
            'Tlalnepantla',
            'Chihuahua',
            'Naucalpan',
            'San Luis Potosí',
            'Hermosillo',
            'Saltillo',
            'Mexicali',
            'Culiacán',
            'Querétaro',
            'Morelia',
            'Torreón',
            'Reynosa',
            'Tlaquepaque',
            'Playa del Carmen',
            'Acapulco',
            'Cancún',
            'Veracruz',
            'Durango',
            'Tampico',
            'Cuernavaca',
            'Chimalhuacán',
            'Nezahualcóyotl',
            'Iztapalapa',
            'Gustavo A. Madero',
            'Álvaro Obregón',
            'Coyoacán',
            'Xochimilco',
            'Tlalpan',
            'Magdalena Contreras',
            'Milpa Alta'
        ];

        // Array de estados mexicanos
        $states = [
            'Aguascalientes',
            'Baja California',
            'Baja California Sur',
            'Campeche',
            'Chiapas',
            'Chihuahua',
            'Ciudad de México',
            'Coahuila',
            'Colima',
            'Durango',
            'Estado de México',
            'Guanajuato',
            'Guerrero',
            'Hidalgo',
            'Jalisco',
            'Michoacán',
            'Morelos',
            'Nayarit',
            'Nuevo León',
            'Oaxaca',
            'Puebla',
            'Querétaro',
            'Quintana Roo',
            'San Luis Potosí',
            'Sinaloa',
            'Sonora',
            'Tabasco',
            'Tamaulipas',
            'Tlaxcala',
            'Veracruz',
            'Yucatán',
            'Zacatecas'
        ];

        // Crear 150 clientes con datos realistas
        for ($i = 1; $i <= 150; $i++) {
            $firstName = $faker->firstName();
            $lastName = $faker->lastName();
            $name = $firstName . ' ' . $lastName;

            // Generar email basado en el nombre
            $email = strtolower(str_replace(' ', '.', $name)) . '@' . $faker->freeEmailDomain();

            // Generar teléfono mexicano realista
            $phone = $faker->numerify('55-####-####'); // Formato mexicano

            // Seleccionar ciudad y estado aleatoriamente
            $city = $faker->randomElement($cities);
            $state = $faker->randomElement($states);

            // Generar dirección realista
            $address = $faker->streetAddress() . ', ' . $city;

            // Generar código postal mexicano
            $postalCode = $faker->numerify('#####');

            // Generar notas ocasionales
            $notes = $faker->optional(0.3)->sentence();

            Client::create([
                'name' => $name,
                'email' => $email,
                'phone' => $phone,
                'address' => $address,
                'city' => $city,
                'state' => $state,
                'country' => 'México',
                'postal_code' => $postalCode,
                'notes' => $notes,
                'created_at' => $faker->dateTimeBetween('-2 years', 'now'),
                'updated_at' => $faker->dateTimeBetween('-1 year', 'now'),
            ]);
        }

        // Crear algunos clientes con datos específicos para testing
        $testClients = [
            [
                'name' => 'Juan Pérez',
                'email' => 'juan.perez@email.com',
                'phone' => '555-0101',
                'address' => 'Av. Reforma 123, Ciudad de México',
                'city' => 'Ciudad de México',
                'state' => 'Ciudad de México',
                'country' => 'México',
                'postal_code' => '06500',
                'notes' => 'Cliente VIP - Descuento especial',
                'created_at' => now()->subMonths(6),
            ],
            [
                'name' => 'María García',
                'email' => 'maria.garcia@email.com',
                'phone' => '555-0102',
                'address' => 'Calle Hidalgo 456, Guadalajara',
                'city' => 'Guadalajara',
                'state' => 'Jalisco',
                'country' => 'México',
                'postal_code' => '44100',
                'notes' => 'Cliente frecuente',
                'created_at' => now()->subMonths(4),
            ],
            [
                'name' => 'Carlos Rodríguez',
                'email' => 'carlos.rodriguez@email.com',
                'phone' => '555-0103',
                'address' => 'Av. Universidad 789, Monterrey',
                'city' => 'Monterrey',
                'state' => 'Nuevo León',
                'country' => 'México',
                'postal_code' => '64000',
                'notes' => 'Cliente corporativo',
                'created_at' => now()->subMonths(3),
            ],
            [
                'name' => 'Ana Martínez',
                'email' => 'ana.martinez@email.com',
                'phone' => '555-0104',
                'address' => 'Blvd. 5 de Mayo 321, Puebla',
                'city' => 'Puebla',
                'state' => 'Puebla',
                'country' => 'México',
                'postal_code' => '72000',
                'notes' => 'Cliente nuevo',
                'created_at' => now()->subMonths(2),
            ],
            [
                'name' => 'Roberto López',
                'email' => 'roberto.lopez@email.com',
                'phone' => '555-0105',
                'address' => 'Calle Juárez 654, Querétaro',
                'city' => 'Querétaro',
                'state' => 'Querétaro',
                'country' => 'México',
                'postal_code' => '76000',
                'notes' => 'Cliente preferente',
                'created_at' => now()->subMonths(1),
            ],
        ];

        foreach ($testClients as $client) {
            Client::create($client);
        }

        $this->command->info('✅ Se crearon 155 clientes exitosamente (150 aleatorios + 5 de prueba)');
    }
}
