<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('clients', function (Blueprint $table) {
            // Hacer el teléfono obligatorio
            $table->string('phone')->nullable(false)->change();

            // Hacer el email opcional (quitar unique constraint primero)
            $table->dropUnique(['email']);
            $table->string('email')->nullable()->change();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('clients', function (Blueprint $table) {
            // Revertir: hacer el teléfono opcional
            $table->string('phone')->nullable()->change();

            // Revertir: hacer el email obligatorio y único
            $table->string('email')->nullable(false)->change();
            $table->unique('email');
        });
    }
};
