<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Admin\FontController;

/*
|--------------------------------------------------------------------------
| Admin Routes
|--------------------------------------------------------------------------
|
| Here you can register admin routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::middleware(['auth', 'admin'])->prefix('admin')->name('admin.')->group(function () {
    
    // Admin Dashboard
    Route::get('/', function () {
        return view('admin.dashboard');
    })->name('dashboard');

    // Font Management Routes
    Route::resource('fonts', FontController::class);
    
    // Additional font routes
    Route::post('fonts/{font}/toggle', [FontController::class, 'toggle'])->name('fonts.toggle');
    Route::get('fonts/{font}/preview', [FontController::class, 'preview'])->name('fonts.preview');
});

